/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.linking;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.event.EventCounter;
import com.swirlds.platform.event.linking.InOrderLinker;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

abstract class AbstractInOrderLinker
implements InOrderLinker {
    private static final int INITIAL_CAPACITY = 1024;
    private static final Duration MINIMUM_LOG_PERIOD = Duration.ofMinutes(1L);
    private final RateLimitedLogger missingParentLogger;
    private final RateLimitedLogger birthRoundMismatchLogger;
    private final RateLimitedLogger timeCreatedMismatchLogger;
    private final SequenceMap<EventDescriptorWrapper, EventImpl> parentDescriptorMap;
    private final Map<Hash, EventImpl> parentHashMap = new HashMap<Hash, EventImpl>(1024);
    private EventWindow eventWindow;

    public AbstractInOrderLinker(@NonNull PlatformContext platformContext) {
        Logger logger = LogManager.getLogger(this.getClass());
        this.missingParentLogger = new RateLimitedLogger(logger, platformContext.getTime(), MINIMUM_LOG_PERIOD);
        this.birthRoundMismatchLogger = new RateLimitedLogger(logger, platformContext.getTime(), MINIMUM_LOG_PERIOD);
        this.timeCreatedMismatchLogger = new RateLimitedLogger(logger, platformContext.getTime(), MINIMUM_LOG_PERIOD);
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.parentDescriptorMap = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
    }

    @Override
    @Nullable
    public EventImpl linkEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            this.ancientEventAdded(event);
            return null;
        }
        EventImpl selfParent = this.getParentToLink(event, event.getSelfParent());
        List otherParents = event.getOtherParents();
        EventImpl otherParent = otherParents.isEmpty() ? null : this.getParentToLink(event, (EventDescriptorWrapper)otherParents.get(0));
        EventImpl linkedEvent = new EventImpl(event, selfParent, otherParent);
        EventCounter.incrementLinkedEventCount();
        EventDescriptorWrapper eventDescriptorWrapper = event.getDescriptor();
        this.parentDescriptorMap.put((Object)eventDescriptorWrapper, (Object)linkedEvent);
        this.parentHashMap.put(eventDescriptorWrapper.hash(), linkedEvent);
        return linkedEvent;
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.parentDescriptorMap.shiftWindow(eventWindow.ancientThreshold(), (descriptor, event) -> {
            this.parentHashMap.remove(descriptor.hash());
            this.eventHasBecomeAncient((EventImpl)event);
        });
    }

    @Override
    public void clear() {
        this.parentDescriptorMap.clear();
        this.parentHashMap.clear();
    }

    protected void childHasMissingParent(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor) {
        this.missingParentLogger.error(LogMarker.EXCEPTION.getMarker(), "Child has a missing parent. This should not be possible. Child: {}, Parent EventDescriptor: {}", new Object[]{child, parentDescriptor});
    }

    protected void parentHasIncorrectBirthRound(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor, @NonNull EventImpl candidateParent) {
        this.birthRoundMismatchLogger.warn(LogMarker.EXCEPTION.getMarker(), "Event has a parent with a different birth round than claimed. Child: {}, parent: {}, claimed birth round: {}, actual birth round: {}", new Object[]{child, candidateParent, parentDescriptor.eventDescriptor().birthRound(), candidateParent.getBirthRound()});
    }

    protected void childTimeIsNotAfterSelfParentTime(@NonNull PlatformEvent child, @NonNull EventImpl candidateParent, @NonNull Instant parentTimeCreated, @NonNull Instant childTimeCreated) {
        this.timeCreatedMismatchLogger.error(LogMarker.EXCEPTION.getMarker(), "Child time created isn't strictly after self parent time created. Child: {}, parent: {}, child time created: {}, parent time created: {}", new Object[]{child, candidateParent, childTimeCreated, parentTimeCreated});
    }

    protected void ancientEventAdded(@NonNull PlatformEvent event) {
    }

    protected void eventHasBecomeAncient(@NonNull EventImpl event) {
    }

    @Nullable
    private EventImpl getParentToLink(@NonNull PlatformEvent child, @Nullable EventDescriptorWrapper parentDescriptor) {
        if (parentDescriptor == null) {
            return null;
        }
        if (this.eventWindow.isAncient(parentDescriptor)) {
            return null;
        }
        EventImpl candidateParent = this.parentHashMap.get(parentDescriptor.hash());
        if (candidateParent == null) {
            this.childHasMissingParent(child, parentDescriptor);
            return null;
        }
        if (candidateParent.getBirthRound() != parentDescriptor.eventDescriptor().birthRound()) {
            this.parentHasIncorrectBirthRound(child, parentDescriptor, candidateParent);
            return null;
        }
        Instant parentTimeCreated = candidateParent.getBaseEvent().getTimeCreated();
        Instant childTimeCreated = child.getTimeCreated();
        if (parentDescriptor.creator().equals((Object)child.getDescriptor().creator()) && parentTimeCreated.compareTo(childTimeCreated) >= 0) {
            this.childTimeIsNotAfterSelfParentTime(child, candidateParent, parentTimeCreated, childTimeCreated);
            return null;
        }
        return candidateParent;
    }
}

