/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.DynamicValue;
import com.swirlds.platform.test.fixtures.event.DynamicValueGenerator;
import com.swirlds.platform.test.fixtures.event.EventUtils;
import com.swirlds.platform.test.fixtures.event.RandomEventUtils;
import com.swirlds.platform.test.fixtures.event.TransactionUtils;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import org.hiero.consensus.model.node.NodeId;

public abstract class AbstractEventSource
implements EventSource {
    private NodeId nodeId;
    private DynamicValueGenerator<Double> newEventWeight;
    private static final double DEFAULT_AVG_TX_SIZE = 3.0;
    private static final double DEFAULT_TX_SIZE_STD_DEV = 1.0;
    private static final double DEFAULT_TX_COUNT_AVG = 3.0;
    private static final double DEFAULT_TX_COUNT_STD_DEV = 3.0;
    protected static final TransactionGenerator DEFAULT_TRANSACTION_GENERATOR = r -> TransactionUtils.randomApplicationTransactions(r, 3.0, 1.0, 3.0, 3.0);
    private long eventCount;
    private DynamicValueGenerator<Integer> otherParentRequestIndex;
    private DynamicValueGenerator<Integer> otherParentProviderIndex;
    private int recentEventRetentionSize;
    private TransactionGenerator transactionGenerator;
    private final boolean useFakeHashes;

    protected AbstractEventSource(boolean useFakeHashes, TransactionGenerator transactionGenerator) {
        this.useFakeHashes = useFakeHashes;
        this.transactionGenerator = transactionGenerator;
        this.nodeId = NodeId.UNDEFINED_NODE_ID;
        this.setNewEventWeight(1.0);
        this.eventCount = 0L;
        this.otherParentRequestIndex = new DynamicValueGenerator<Integer>(EventUtils.integerPowerDistribution(0.95));
        this.otherParentProviderIndex = new DynamicValueGenerator<Integer>(EventUtils.staticDynamicValue(0));
        this.recentEventRetentionSize = 100;
    }

    protected AbstractEventSource(AbstractEventSource that) {
        this.useFakeHashes = that.useFakeHashes;
        this.transactionGenerator = that.transactionGenerator;
        this.nodeId = that.nodeId;
        this.newEventWeight = that.newEventWeight.cleanCopy();
        this.eventCount = 0L;
        this.otherParentRequestIndex = that.otherParentRequestIndex.cleanCopy();
        this.otherParentProviderIndex = that.otherParentProviderIndex.cleanCopy();
        this.recentEventRetentionSize = that.recentEventRetentionSize;
    }

    protected void pruneEventList(LinkedList<EventImpl> events) {
        if (events.size() > this.getRecentEventRetentionSize()) {
            events.removeLast();
        }
    }

    @Override
    public void reset() {
        this.eventCount = 0L;
        this.otherParentRequestIndex.reset();
        this.otherParentProviderIndex.reset();
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @Override
    public EventSource setNodeId(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.nodeId = nodeId;
        return this;
    }

    @Override
    public double getNewEventWeight(Random random, long eventIndex) {
        return this.newEventWeight.get(random, eventIndex);
    }

    @Override
    public void setNewEventWeight(DynamicValue<Double> dynamicWeight) {
        this.newEventWeight = new DynamicValueGenerator<Double>(dynamicWeight);
    }

    @Override
    public EventImpl generateEvent(@NonNull Random random, long eventIndex, @Nullable EventSource otherParent, @NonNull Instant timestamp, long birthRound) {
        Objects.requireNonNull(random);
        Objects.requireNonNull(timestamp);
        int otherParentIndex = Math.max(this.getRequestedOtherParentAge(random, eventIndex), otherParent.getProvidedOtherParentAge(random, eventIndex));
        EventImpl otherParentEvent = otherParent == null ? null : otherParent.getRecentEvent(random, otherParentIndex);
        EventImpl latestSelfEvent = this.getLatestEvent(random);
        EventImpl event = RandomEventUtils.randomEventWithTimestamp(random, this.nodeId, timestamp, birthRound, this.transactionGenerator.generate(random), latestSelfEvent, otherParentEvent, this.useFakeHashes);
        ++this.eventCount;
        this.setLatestEvent(random, event);
        return event;
    }

    @Override
    public EventSource setTransactionGenerator(TransactionGenerator transactionGenerator) {
        this.transactionGenerator = transactionGenerator;
        return this;
    }

    @Override
    public int getRequestedOtherParentAge(Random random, long eventIndex) {
        return this.otherParentRequestIndex.get(random, eventIndex);
    }

    @Override
    public EventSource setRequestedOtherParentAgeDistribution(DynamicValue<Integer> otherParentIndex) {
        this.otherParentRequestIndex = new DynamicValueGenerator<Integer>(otherParentIndex);
        return this;
    }

    @Override
    public int getProvidedOtherParentAge(Random random, long eventIndex) {
        return this.otherParentProviderIndex.get(random, eventIndex);
    }

    @Override
    public EventSource setProvidedOtherParentAgeDistribution(DynamicValue<Integer> otherParentIndex) {
        this.otherParentProviderIndex = new DynamicValueGenerator<Integer>(otherParentIndex);
        return this;
    }

    @Override
    public int getRecentEventRetentionSize() {
        return this.recentEventRetentionSize;
    }

    @Override
    public EventSource setRecentEventRetentionSize(int recentEventRetentionSize) {
        this.recentEventRetentionSize = recentEventRetentionSize;
        return this;
    }
}

