/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.resubmitter;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.event.resubmitter.TransactionResubmitter;
import com.swirlds.platform.event.resubmitter.TransactionResubmitterMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class DefaultTransactionResubmitter
implements TransactionResubmitter {
    private EventWindow eventWindow;
    private final long maxSignatureResubmitAge;
    private final TransactionResubmitterMetrics metrics;

    public DefaultTransactionResubmitter(@NonNull PlatformContext platformContext) {
        this.maxSignatureResubmitAge = ((StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class)).maxSignatureResubmitAge();
        this.metrics = new TransactionResubmitterMetrics(platformContext);
    }

    @Override
    @NonNull
    public List<Bytes> resubmitStaleTransactions(@NonNull PlatformEvent event) {
        if (this.eventWindow == null) {
            throw new IllegalStateException("Event window is not set");
        }
        ArrayList<Bytes> transactionsToResubmit = new ArrayList<Bytes>();
        return transactionsToResubmit;
    }

    @Override
    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
    }
}

