/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.threading;

import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.concurrent.ThrowingRunnable;

public class SyncPhaseParallelExecutor
implements ParallelExecutor {
    private static final int PHASE_1 = 1;
    private static final int PHASE_2 = 2;
    private static final int PHASE_3 = 3;
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private static final int NUMBER_OF_PHASES = 3;
    private static final Duration WAIT_TIME = Duration.ofSeconds(60L);
    private final ExecutorService executor;
    private final AtomicReference<ThreadStatus> threadStatus;
    private volatile int phase;
    private final Runnable afterPhase1;
    private final Runnable afterPhase2;
    private final Runnable beforePhase3;
    private final boolean waitForSecondThread;

    public SyncPhaseParallelExecutor(ThreadManager threadManager, Runnable afterPhase1, Runnable afterPhase2) {
        this(threadManager, afterPhase1, afterPhase2, null, true);
    }

    public SyncPhaseParallelExecutor(ThreadManager threadManager, Runnable afterPhase1, Runnable afterPhase2, boolean waitForSecondThread) {
        this(threadManager, afterPhase1, afterPhase2, null, waitForSecondThread);
    }

    public SyncPhaseParallelExecutor(ThreadManager threadManager, Runnable afterPhase1, Runnable afterPhase2, Runnable beforePhase3, boolean waitForSecondThread) {
        this.afterPhase1 = SyncPhaseParallelExecutor.noopIfNull(afterPhase1);
        this.afterPhase2 = SyncPhaseParallelExecutor.noopIfNull(afterPhase2);
        this.beforePhase3 = SyncPhaseParallelExecutor.noopIfNull(beforePhase3);
        this.waitForSecondThread = waitForSecondThread;
        this.executor = Executors.newCachedThreadPool(threadManager.createThreadFactory("SyncPhase", "SyncPhase"));
        this.threadStatus = new AtomicReference<ThreadStatus>(ThreadStatus.WAITING_FOR_FIRST_THREAD);
        this.phase = 1;
    }

    private void incPhase() {
        this.phase = this.phase % 3 + 1;
    }

    public int getPhase() {
        return this.phase;
    }

    public <T> T doParallel(Callable<T> task1, Callable<Void> backgroundTask, Runnable onThrow) throws ParallelExecutionException {
        return this.doParallel(task1, backgroundTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doParallel(Callable<T> task1, Callable<Void> backgroundTask) throws ParallelExecutionException {
        if (this.phase == 3) {
            this.beforePhase3.run();
        }
        T result = null;
        try {
            Future<T> future1 = this.executor.submit(task1);
            backgroundTask.call();
            result = future1.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ParallelExecutionException((Throwable)e);
        }
        catch (Exception e) {
            throw new ParallelExecutionException((Throwable)e);
        }
        try {
            AtomicReference<ThreadStatus> e = this.threadStatus;
            synchronized (e) {
                if (this.waitForSecondThread && this.threadStatus.get() == ThreadStatus.WAITING_FOR_FIRST_THREAD) {
                    this.threadStatus.set(ThreadStatus.WAITING_FOR_SECOND_THREAD);
                    while (this.threadStatus.get() != ThreadStatus.SECOND_THREAD_DONE) {
                        this.threadStatus.wait(WAIT_TIME.toMillis());
                    }
                    this.threadStatus.set(ThreadStatus.WAITING_FOR_FIRST_THREAD);
                    return result;
                }
                if (this.phase == 1) {
                    this.afterPhase1.run();
                } else if (this.phase == 2) {
                    this.afterPhase2.run();
                }
                this.incPhase();
                this.threadStatus.set(ThreadStatus.SECOND_THREAD_DONE);
                this.threadStatus.notifyAll();
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ParallelExecutionException((Throwable)e);
        }
    }

    public void doParallel(Runnable onThrow, ThrowingRunnable foregroundTask, ThrowingRunnable ... backgroundTasks) throws ParallelExecutionException {
        throw new UnsupportedOperationException();
    }

    private static Runnable noopIfNull(Runnable runnable) {
        if (runnable == null) {
            return NOOP_RUNNABLE;
        }
        return runnable;
    }

    public boolean isImmutable() {
        return false;
    }

    public void start() {
    }

    private static enum ThreadStatus {
        WAITING_FOR_FIRST_THREAD,
        WAITING_FOR_SECOND_THREAD,
        SECOND_THREAD_DONE;

    }
}

