/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.reconnect.ReconnectLearnerThrottle;
import com.swirlds.platform.reconnect.ReconnectNetworkHelper;
import com.swirlds.platform.reconnect.ReconnectPlatformHelper;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.status.PlatformStatus;

public class ReconnectController
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ReconnectController.class);
    private final ReconnectPlatformHelper platformHelper;
    private final ReconnectNetworkHelper networkHelper;
    private final Semaphore threadRunning;
    private final Runnable resumeGossip;
    private final SignedStateValidator validator;
    private final ThreadManager threadManager;
    private final Duration minTimeBetweenReconnects;
    private final ReconnectLearnerThrottle reconnectLearnerThrottle;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);

    public ReconnectController(@NonNull ReconnectConfig reconnectConfig, @NonNull ThreadManager threadManager, @NonNull ReconnectPlatformHelper platformHelper, @NonNull ReconnectNetworkHelper networkHelper, @NonNull Runnable resumeGossip, @NonNull ReconnectLearnerThrottle reconnectLearnerThrottle, @NonNull SignedStateValidator validator) {
        this.threadManager = Objects.requireNonNull(threadManager);
        this.platformHelper = Objects.requireNonNull(platformHelper);
        this.networkHelper = Objects.requireNonNull(networkHelper);
        this.resumeGossip = Objects.requireNonNull(resumeGossip);
        this.reconnectLearnerThrottle = Objects.requireNonNull(reconnectLearnerThrottle);
        this.threadRunning = new Semaphore(1);
        this.minTimeBetweenReconnects = reconnectConfig.minimumTimeBetweenReconnects();
        this.validator = Objects.requireNonNull(validator);
    }

    public void start() {
        if (!this.threadRunning.tryAcquire()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Attempting to start reconnect controller while its already running");
            return;
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "Starting ReconnectController");
        ((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(this.threadManager).setComponent("reconnect")).setThreadName("reconnect-controller")).setRunnable((Runnable)this).build(true);
    }

    @Override
    public void run() {
        try {
            while (!this.executeReconnect()) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Reconnect failed, retrying");
                Thread.sleep(this.minTimeBetweenReconnects.toMillis());
            }
        }
        catch (InterruptedException | RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unexpected error occurred while reconnecting", (Throwable)e);
            SystemExitUtils.exitSystem(SystemExitCode.RECONNECT_FAILURE);
        }
        finally {
            this.threadRunning.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeReconnect() throws InterruptedException {
        this.reconnectLearnerThrottle.exitIfReconnectIsDisabled();
        this.platformHelper.prepareForReconnect();
        logger.info(LogMarker.RECONNECT.getMarker(), "waiting for reconnect connection");
        try {
            logger.info(LogMarker.RECONNECT.getMarker(), "acquired reconnect connection");
            try (ReservedSignedState reservedState = this.networkHelper.receiveSignedState(this.validator);){
                SignedStateFileReader.registerServiceStates(reservedState.get());
                this.reconnectLearnerThrottle.successfulReconnect();
                if (!this.platformHelper.loadSignedState(reservedState.get())) {
                    this.reconnectLearnerThrottle.handleFailedReconnect();
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (RuntimeException e) {
            this.reconnectLearnerThrottle.handleFailedReconnect();
            logger.info(LogMarker.RECONNECT.getMarker(), "receiving signed state failed", (Throwable)e);
            return false;
        }
        this.resumeGossip.run();
        return true;
    }

    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        PlatformStatus previousState = this.platformStatus.getAndSet(status);
        if (status != previousState && PlatformStatus.BEHIND == status) {
            this.start();
        }
    }
}

