/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.test.fixtures.MapReadableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapReadableStates
implements ReadableStates {
    private final Map<String, ?> states;

    public MapReadableStates(@NonNull Map<String, ?> states) {
        this.states = Objects.requireNonNull(states);
    }

    @NonNull
    public <K, V> ReadableKVState<K, V> get(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown k/v state key " + stateKey);
        }
        return (ReadableKVState)state;
    }

    @NonNull
    public <T> ReadableSingletonState<T> getSingleton(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown singleton state key " + stateKey);
        }
        return (ReadableSingletonState)state;
    }

    @NonNull
    public <E> ReadableQueueState<E> getQueue(@NonNull String stateKey) {
        Object state = this.states.get(Objects.requireNonNull(stateKey));
        if (state == null) {
            throw new IllegalArgumentException("Unknown queue state key " + stateKey);
        }
        return (ReadableQueueState)state;
    }

    public boolean contains(@NonNull String stateKey) {
        return this.states.containsKey(stateKey);
    }

    @NonNull
    public Set<String> stateKeys() {
        return Collections.unmodifiableSet(this.states.keySet());
    }

    public int size() {
        return this.states.size();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> states = new HashMap<String, Object>();

        Builder() {
        }

        @NonNull
        public Builder state(@NonNull MapReadableKVState state) {
            this.states.put(state.getStateKey(), (Object)state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull ReadableSingletonState<?> state) {
            this.states.put(state.getStateKey(), state);
            return this;
        }

        @NonNull
        public Builder state(@NonNull ReadableQueueState<?> state) {
            this.states.put(state.getStateKey(), state);
            return this;
        }

        @NonNull
        public MapReadableStates build() {
            return new MapReadableStates(new HashMap<String, Object>(this.states));
        }
    }
}

