/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.hash;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.hash.FutureMerkleHash;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import java.util.Iterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import org.hiero.base.concurrent.AbstractTask;
import org.hiero.base.concurrent.futures.StandardFuture;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;

public class MerkleHashBuilder {
    private final ForkJoinPool threadPool;
    private final MerkleCryptography merkleCryptography;

    public MerkleHashBuilder(MerkleCryptography merkleCryptography, int cpuThreadCount) {
        this.merkleCryptography = merkleCryptography;
        this.threadPool = new ForkJoinPool(cpuThreadCount);
    }

    private static boolean filter(MerkleNode node) {
        if (node == null) {
            return false;
        }
        if (node.isSelfHashing()) {
            return true;
        }
        return node.getHash() == null;
    }

    private static boolean descendantFilter(MerkleNode child) {
        if (child.isSelfHashing()) {
            return false;
        }
        return child.getHash() == null;
    }

    public Hash digestTreeSync(MerkleNode root) {
        if (root == null) {
            return Cryptography.NULL_HASH;
        }
        MerkleIterator<MerkleNode> iterator = root.treeIterator().setFilter(MerkleHashBuilder::filter).setDescendantFilter(MerkleHashBuilder::descendantFilter);
        this.hashSubtree(iterator);
        return root.getHash();
    }

    public Future<Hash> digestTreeAsync(MerkleNode root) {
        if (root == null) {
            return new StandardFuture((Object)Cryptography.NULL_HASH);
        }
        if (root.getHash() != null) {
            return new StandardFuture((Object)root.getHash());
        }
        FutureMerkleHash resultFuture = new FutureMerkleHash();
        ResultTask resultTask = new ResultTask(root, resultFuture);
        new TraverseTask(root, resultTask).send();
        return resultFuture;
    }

    private void hashSubtree(Iterator<MerkleNode> it) {
        while (it.hasNext()) {
            MerkleNode node = it.next();
            if (node.getHash() != null) continue;
            this.merkleCryptography.digestSync(node, Cryptography.DEFAULT_DIGEST_TYPE);
        }
    }

    class ResultTask
    extends AbstractTask {
        final FutureMerkleHash future;
        final MerkleNode root;

        ResultTask(MerkleNode root, FutureMerkleHash future) {
            super(MerkleHashBuilder.this.threadPool, 1);
            this.root = root;
            this.future = future;
        }

        protected boolean onExecute() {
            this.future.set(this.root.getHash());
            return true;
        }

        public void onException(Throwable ex) {
            if (!this.future.isCancelled()) {
                this.future.cancelWithException(ex);
            }
        }
    }

    class TraverseTask
    extends AbstractTask {
        final MerkleNode node;
        final AbstractTask out;

        TraverseTask(MerkleNode node, AbstractTask out) {
            super(MerkleHashBuilder.this.threadPool, 1);
            this.node = node;
            this.out = out;
        }

        protected boolean onExecute() {
            if (this.node == null || this.node.getHash() != null) {
                this.out.send();
            } else if (this.node.isLeaf()) {
                MerkleHashBuilder.this.merkleCryptography.digestSync(this.node.asLeaf());
                this.out.send();
            } else {
                MerkleInternal internal = this.node.asInternal();
                int nChildren = internal.getNumberOfChildren();
                if (nChildren == 0) {
                    MerkleHashBuilder.this.merkleCryptography.digestSync(internal, true);
                    this.out.send();
                } else {
                    ComputeTask compute = new ComputeTask(internal, nChildren, this.out);
                    for (int childIndex = 0; childIndex < nChildren; ++childIndex) {
                        MerkleNode child = internal.getChild(childIndex);
                        new TraverseTask(child, compute).send();
                    }
                }
            }
            return true;
        }

        protected void onException(Throwable t) {
            if (!this.out.isCompletedAbnormally()) {
                this.out.completeExceptionally(t);
            }
        }
    }

    class ComputeTask
    extends AbstractTask {
        final MerkleInternal internal;
        final AbstractTask out;

        ComputeTask(MerkleInternal internal, int n, AbstractTask out) {
            super(MerkleHashBuilder.this.threadPool, n);
            this.internal = internal;
            this.out = out;
        }

        protected boolean onExecute() {
            MerkleHashBuilder.this.merkleCryptography.digestSync(this.internal, true);
            this.out.send();
            return true;
        }

        public void onException(Throwable ex) {
            if (!this.out.isCompletedAbnormally()) {
                this.out.completeExceptionally(ex);
            }
        }
    }
}

