/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.stale;

import com.swirlds.component.framework.transformers.RoutableData;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.stale.StaleEventDetector;
import org.hiero.consensus.event.creator.impl.stale.StaleEventDetectorMetrics;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.StaleEventDetectorOutput;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class DefaultStaleEventDetector
implements StaleEventDetector {
    private final NodeId selfId;
    private final StandardSequenceMap<EventDescriptorWrapper, PlatformEvent> selfEvents;
    private EventWindow currentEventWindow;
    private final StaleEventDetectorMetrics metrics;

    public DefaultStaleEventDetector(@NonNull Metrics metrics, @NonNull NodeId selfId) {
        this.selfId = Objects.requireNonNull(selfId);
        this.selfEvents = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
        this.metrics = new StaleEventDetectorMetrics(metrics);
    }

    @Override
    @NonNull
    public List<RoutableData<StaleEventDetectorOutput>> addSelfEvent(@NonNull PlatformEvent event) {
        if (this.currentEventWindow == null) {
            throw new IllegalStateException("Event window must be set before adding self events");
        }
        RoutableData selfEvent = new RoutableData((Enum)StaleEventDetectorOutput.SELF_EVENT, (Object)event);
        if (this.currentEventWindow.isAncient(event)) {
            this.handleStaleEvent(event);
            RoutableData staleEvent = new RoutableData((Enum)StaleEventDetectorOutput.STALE_SELF_EVENT, (Object)event);
            return List.of(selfEvent, staleEvent);
        }
        this.selfEvents.put((Object)event.getDescriptor(), (Object)event);
        return List.of(selfEvent);
    }

    @Override
    @NonNull
    public List<RoutableData<StaleEventDetectorOutput>> addConsensusRound(@NonNull ConsensusRound consensusRound) {
        for (PlatformEvent event2 : consensusRound.getConsensusEvents()) {
            if (!event2.getCreatorId().equals((Object)this.selfId)) continue;
            this.selfEvents.remove((Object)event2.getDescriptor());
        }
        ArrayList staleEvents = new ArrayList();
        this.currentEventWindow = consensusRound.getEventWindow();
        this.selfEvents.shiftWindow(this.currentEventWindow.ancientThreshold(), (descriptor, event) -> staleEvents.add(event));
        ArrayList<RoutableData<StaleEventDetectorOutput>> output = new ArrayList<RoutableData<StaleEventDetectorOutput>>(staleEvents.size());
        for (PlatformEvent event3 : staleEvents) {
            this.handleStaleEvent(event3);
            output.add((RoutableData<StaleEventDetectorOutput>)new RoutableData((Enum)StaleEventDetectorOutput.STALE_SELF_EVENT, (Object)event3));
        }
        return output;
    }

    @Override
    public void setInitialEventWindow(@NonNull EventWindow initialEventWindow) {
        this.currentEventWindow = Objects.requireNonNull(initialEventWindow);
        this.selfEvents.shiftWindow(this.currentEventWindow.ancientThreshold());
    }

    @Override
    public void clear() {
        this.selfEvents.clear();
        this.currentEventWindow = null;
    }

    private void handleStaleEvent(@NonNull PlatformEvent event) {
        this.metrics.reportStaleEvent(event);
    }
}

