/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.SingletonIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

final class ImmutableIntSingletonStack
implements ImmutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int element1;

    ImmutableIntSingletonStack(int element) {
        this.element1 = element;
    }

    public IntIterator intIterator() {
        return new SingletonIntIterator(this.element1);
    }

    public void each(IntProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public int peek() {
        return this.element1;
    }

    public IntList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        if (count == 1) {
            return IntArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public int peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableIntStack select(IntPredicate predicate) {
        return predicate.accept(this.element1) ? IntStacks.immutable.with(this.element1) : IntStacks.immutable.with();
    }

    public ImmutableIntStack reject(IntPredicate predicate) {
        return predicate.accept(this.element1) ? IntStacks.immutable.with() : IntStacks.immutable.with(this.element1);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public long sum() {
        return this.element1;
    }

    public int max() {
        return this.element1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.element1;
    }

    public int min() {
        return this.element1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public int[] toSortedArray() {
        return new int[]{this.element1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.element1);
    }

    public int[] toArray() {
        return new int[]{this.element1};
    }

    public int[] toArray(int[] target) {
        if (target.length < 1) {
            target = new int[]{this.element1};
        } else {
            target[0] = this.element1;
        }
        return target;
    }

    public boolean contains(int value) {
        return this.element1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.element1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.element1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.element1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableIntStack toImmutable() {
        return this;
    }

    public ImmutableIntStack push(int element) {
        return IntStacks.immutable.with(new int[]{this.element1, element});
    }

    public ImmutableIntStack pop() {
        return IntStacks.immutable.with();
    }

    public ImmutableIntStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return IntStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public int getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(int value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + "]";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableIntStack toStack() {
        return IntStacks.mutable.with(new int[]{this.element1});
    }
}

