/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkle.test.fixtures.map.util;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.utility.Keyed;
import com.swirlds.common.test.fixtures.dummy.Key;
import com.swirlds.common.test.fixtures.dummy.Value;
import com.swirlds.merkle.test.fixtures.map.util.MapMutatorSet;
import com.swirlds.merkle.tree.MerkleBinaryTree;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public final class MerkleMapTestUtil {
    public static final Random random = new Random();
    private static final File LOG_PATH = MerkleMapTestUtil.canonicalFile(".", "src", "test", "resources", "log4j2-test.xml");

    private MerkleMapTestUtil() {
    }

    private static File canonicalFile(String ... names) {
        return MerkleMapTestUtil.canonicalFile(new File("."), names);
    }

    private static File canonicalFile(File start, String ... names) {
        File f = start;
        try {
            f = f.getCanonicalFile();
            for (String name : names) {
                f = new File(f, name).getCanonicalFile();
            }
        }
        catch (IOException e) {
            f = null;
        }
        return f;
    }

    public static void loadLogging() {
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.setConfigLocation(LOG_PATH.toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V extends MerkleNode & Keyed<?>> void updateCache(V original) {
    }

    public static void insertIntoMap(int size, Map<Key, Value> fcm) {
        MerkleMapTestUtil.insertIntoMap(0, size, fcm);
    }

    public static void insertIntoMap(int startIndex, int endIndex, Map<Key, Value> fcm) {
        MapMutatorSet.insertKeyValueIntoMap(startIndex, endIndex, fcm);
    }

    public static void insertIntoTreeWithoutBalanceCheck(int startIndex, int endIndex, MerkleBinaryTree<Value> tree) {
        for (int index = startIndex; index < endIndex; ++index) {
            Key key = new Key(new long[]{index, index, index});
            Value value = new Value((long)index, (long)index, (long)index, true);
            value.setKey(key);
            tree.insert((MerkleNode)value, MerkleMapTestUtil::updateCache);
        }
    }
}

