/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.api.ContractChangeSummary;
import com.hedera.node.app.service.token.impl.ReadableAccountStoreImpl;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class WritableAccountStore
extends ReadableAccountStoreImpl {
    private final WritableEntityCounters entityCounters;

    public WritableAccountStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.entityCounters = entityCounters;
    }

    protected WritableKVState<AccountID, Account> accountState() {
        return (WritableKVState)super.accountState();
    }

    protected WritableKVState<ProtoBytes, AccountID> aliases() {
        return (WritableKVState)super.aliases();
    }

    public void put(@NonNull Account account) {
        Objects.requireNonNull(account);
        WritableAccountStore.requireNotDefault(account.accountIdOrThrow());
        this.accountState().put((Object)account.accountIdOrThrow(), (Object)account);
    }

    public void putAndIncrementCount(@NonNull Account account) {
        this.put(account);
        this.entityCounters.incrementEntityTypeCount(EntityType.ACCOUNT);
    }

    public void putAlias(@NonNull Bytes alias, AccountID accountId) {
        Objects.requireNonNull(alias);
        this.requireNotDefault(alias);
        WritableAccountStore.requireNotDefault(accountId);
        if (AliasUtils.isAlias((AccountID)accountId)) {
            throw new IllegalArgumentException("The account ID used with putAlias must have a number and not an alias");
        }
        if (alias.length() == 0L) {
            throw new IllegalArgumentException("Alias cannot be empty");
        }
        this.aliases().put((Object)new ProtoBytes(alias), (Object)accountId);
    }

    public void putAndIncrementCountAlias(@NonNull Bytes alias, AccountID accountId) {
        this.putAlias(alias, accountId);
        this.entityCounters.incrementEntityTypeCount(EntityType.ALIAS);
    }

    public void removeAlias(@NonNull Bytes alias) {
        Objects.requireNonNull(alias);
        if (alias.length() > 0L) {
            Key key;
            Bytes evmAddress;
            if (!AliasUtils.isOfEvmAddressSize((Bytes)alias) && (evmAddress = AliasUtils.extractEvmAddress((Key)(key = AliasUtils.asKeyFromAlias((Bytes)alias)))) != null) {
                this.aliases().remove((Object)new ProtoBytes(evmAddress));
                this.entityCounters.decrementEntityTypeCounter(EntityType.ALIAS);
            }
            this.aliases().remove((Object)new ProtoBytes(alias));
            this.entityCounters.decrementEntityTypeCounter(EntityType.ALIAS);
        }
    }

    @Nullable
    public Account get(@NonNull AccountID accountID) {
        return this.getAccountLeaf(Objects.requireNonNull(accountID));
    }

    @Nullable
    public Account getOriginalValue(@NonNull AccountID id) {
        Objects.requireNonNull(id);
        AccountID accountId = id.account().kind() == AccountID.AccountOneOfType.ACCOUNT_NUM ? id : null;
        return accountId == null ? null : (Account)this.accountState().getOriginalValue((Object)accountId);
    }

    @NonNull
    public Set<AccountID> modifiedAccountsInState() {
        return this.accountState().modifiedKeys();
    }

    @NonNull
    public ContractChangeSummary summarizeContractChanges() {
        ArrayList newContractIds = new ArrayList();
        ArrayList updates = new ArrayList();
        this.accountState().modifiedKeys().forEach(accountId -> {
            Account oldAccount;
            Account newAccount = (Account)this.accountState().get(accountId);
            if (newAccount != null && newAccount.smartContract() && ((oldAccount = (Account)this.accountState().getOriginalValue(accountId)) == null || !oldAccount.smartContract() || oldAccount.ethereumNonce() != newAccount.ethereumNonce())) {
                ContractID contractId = ContractID.newBuilder().shardNum(accountId.shardNum()).realmNum(accountId.realmNum()).contractNum(accountId.accountNumOrThrow().longValue()).build();
                if (!newAccount.deleted()) {
                    updates.add(new ContractNonceInfo(contractId, newAccount.ethereumNonce()));
                }
                if (oldAccount == null || !oldAccount.smartContract()) {
                    newContractIds.add(contractId);
                }
            }
        });
        return new ContractChangeSummary(newContractIds, updates);
    }

    @NonNull
    public Set<ProtoBytes> modifiedAliasesInState() {
        return this.aliases().modifiedKeys();
    }

    public static void requireNotDefault(@NonNull AccountID accountId) {
        if (accountId.equals((Object)AccountID.DEFAULT)) {
            throw new IllegalArgumentException("Account ID cannot be default");
        }
    }

    private void requireNotDefault(@NonNull Bytes alias) {
        if (alias.equals((Object)Bytes.EMPTY)) {
            throw new IllegalArgumentException("Account ID cannot be default");
        }
    }
}

