/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.StartupNetworks;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.spi.FilteredWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;

public record MigrationContextImpl(@NonNull ReadableStates previousStates, @NonNull WritableStates newStates, @NonNull Configuration appConfig, @NonNull Configuration platformConfig, @Nullable SemanticVersion previousVersion, long roundNumber, @NonNull Map<String, Object> sharedValues, @NonNull StartupNetworks startupNetworks) implements MigrationContext
{
    public MigrationContextImpl {
        Objects.requireNonNull(previousStates);
        Objects.requireNonNull(newStates);
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(platformConfig);
    }

    public void copyAndReleaseOnDiskState(@NonNull String stateKey) {
        Objects.requireNonNull(stateKey);
        WritableStates writableStates = this.newStates;
        if (writableStates instanceof VirtualMapState.MerkleWritableStates) {
            VirtualMapState.MerkleWritableStates merkleWritableStates = (VirtualMapState.MerkleWritableStates)writableStates;
            merkleWritableStates.copyAndReleaseVirtualMap(stateKey);
        } else {
            FilteredWritableStates filteredWritableStates;
            writableStates = this.newStates;
            if (writableStates instanceof FilteredWritableStates && (writableStates = (filteredWritableStates = (FilteredWritableStates)writableStates).getDelegate()) instanceof VirtualMapState.MerkleWritableStates) {
                VirtualMapState.MerkleWritableStates merkleWritableStates = (VirtualMapState.MerkleWritableStates)writableStates;
                merkleWritableStates.copyAndReleaseVirtualMap(stateKey);
            } else {
                throw new UnsupportedOperationException("On-disk state is inaccessible");
            }
        }
    }
}

