/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.util;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class FileUtilities {
    private FileUtilities() {
        throw new IllegalStateException("Utility class");
    }

    @NonNull
    public static Bytes getFileContent(@NonNull State state, @NonNull FileID fileID) {
        ReadableStates states = state.getReadableStates("FileService");
        ReadableKVState filesMap = states.get("FILES");
        File file = (File)filesMap.get((Object)fileID);
        return file != null ? file.contents() : Bytes.EMPTY;
    }

    public static void observePropertiesAndPermissions(@NonNull State state, @NonNull Configuration config, @NonNull SpecialFilesObserver observer) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(config);
        Objects.requireNonNull(observer);
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        FileUtilities.observePropertiesAndPermissions(state, FileUtilities.createFileID(filesConfig.networkProperties(), config), FileUtilities.createFileID(filesConfig.hapiPermissions(), config), observer);
    }

    private static void observePropertiesAndPermissions(@NonNull State state, @NonNull FileID propertiesId, @NonNull FileID permissionsId, @NonNull SpecialFilesObserver observer) {
        observer.acceptPropertiesAndPermissions(FileUtilities.getFileContent(state, propertiesId), FileUtilities.getFileContent(state, permissionsId));
    }

    public static FileID createFileID(long fileNum, @NonNull Configuration configuration) {
        HederaConfig hederaConfig = (HederaConfig)configuration.getConfigData(HederaConfig.class);
        return FileID.newBuilder().realmNum(hederaConfig.realm()).shardNum(hederaConfig.shard()).fileNum(fileNum).build();
    }

    @FunctionalInterface
    public static interface SpecialFilesObserver {
        public void acceptPropertiesAndPermissions(Bytes var1, Bytes var2);
    }
}

