/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.ethereum.EthTxSigs;
import com.hedera.node.app.service.contract.impl.annotations.ChildTransactionResourcePrices;
import com.hedera.node.app.service.contract.impl.annotations.InitialState;
import com.hedera.node.app.service.contract.impl.annotations.TopLevelResourcePrices;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.TransactionConfigModule;
import com.hedera.node.app.service.contract.impl.exec.TransactionInitialStateModule;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.gas.CanonicalDispatchPrices;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.scope.HandleHederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HandleHederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HandleSystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.SystemContractOperations;
import com.hedera.node.app.service.contract.impl.exec.tracers.EvmActionTracer;
import com.hedera.node.app.service.contract.impl.exec.utils.ActionStack;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadataRef;
import com.hedera.node.app.service.contract.impl.hevm.HandleContextHevmBlocks;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmBlocks;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmVersion;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.hevm.HydratedEthTxData;
import com.hedera.node.app.service.contract.impl.infra.EthTxSigsCache;
import com.hedera.node.app.service.contract.impl.infra.EthereumCallDataHydration;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.state.ScopedEvmFrameStateFactory;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.ComputeDispatchFeesAsTopLevel;
import com.hedera.node.app.spi.workflows.FunctionalityResourcePrices;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

@Module(includes={TransactionConfigModule.class, TransactionInitialStateModule.class})
public interface TransactionModule {
    @Provides
    @TransactionScope
    public static TransactionProcessor provideTransactionProcessor(@NonNull ContractsConfig contractsConfig, @NonNull Map<HederaEvmVersion, TransactionProcessor> processors) {
        return processors.get((Object)HederaEvmVersion.EVM_VERSIONS.get(contractsConfig.evmVersion()));
    }

    @Provides
    @TransactionScope
    public static FeatureFlags provideFeatureFlags(@NonNull TransactionProcessor processor) {
        return processor.featureFlags();
    }

    @Provides
    @TransactionScope
    public static TinybarValues provideTinybarValues(@TopLevelResourcePrices @NonNull FunctionalityResourcePrices topLevelResourcePrices, @ChildTransactionResourcePrices @NonNull FunctionalityResourcePrices childTransactionResourcePrices, @NonNull ExchangeRate exchangeRate) {
        return TinybarValues.forTransactionWith(exchangeRate, topLevelResourcePrices, childTransactionResourcePrices);
    }

    @Provides
    @TransactionScope
    public static SystemContractGasCalculator provideSystemContractGasCalculator(@NonNull HandleContext context, @NonNull CanonicalDispatchPrices canonicalDispatchPrices, @NonNull TinybarValues tinybarValues) {
        return new SystemContractGasCalculator(tinybarValues, canonicalDispatchPrices, (body, payerId) -> context.dispatchComputeFees(body, payerId, ComputeDispatchFeesAsTopLevel.NO).totalFee());
    }

    @Provides
    @TransactionScope
    public static Instant provideConsensusTime(@NonNull HandleContext context) {
        return Objects.requireNonNull(context).consensusNow();
    }

    @Provides
    @TransactionScope
    @TopLevelResourcePrices
    public static FunctionalityResourcePrices provideTopLevelResourcePrices(@NonNull HederaFunctionality functionality, @NonNull HandleContext context) {
        return context.resourcePriceCalculator().resourcePricesFor(functionality, SubType.DEFAULT);
    }

    @Provides
    @TransactionScope
    @ChildTransactionResourcePrices
    public static FunctionalityResourcePrices provideChildTransactionResourcePrices(@NonNull HandleContext context) {
        return context.resourcePriceCalculator().resourcePricesFor(HederaFunctionality.CONTRACT_CALL, SubType.DEFAULT);
    }

    @Provides
    @TransactionScope
    public static ExchangeRate provideExchangeRate(@NonNull Instant now, @NonNull HandleContext context) {
        return context.exchangeRateInfo().activeRate(now);
    }

    @Provides
    @TransactionScope
    @Nullable
    public static HydratedEthTxData maybeProvideHydratedEthTxData(@NonNull HandleContext context, @NonNull EthereumCallDataHydration hydration, @NonNull HederaConfig hederaConfig, @InitialState @NonNull ReadableFileStore fileStore) {
        TransactionBody body = context.body();
        return body.hasEthereumTransaction() ? hydration.tryToHydrate(body.ethereumTransactionOrThrow(), fileStore, hederaConfig.firstUserEntity()) : null;
    }

    @Provides
    @TransactionScope
    @Nullable
    public static Key provideSenderEcdsaKey(@NonNull EthTxSigsCache ethTxSigsCache, @Nullable HydratedEthTxData hydratedEthTxData) {
        if (hydratedEthTxData != null && hydratedEthTxData.isAvailable()) {
            EthTxSigs ethTxSigs = ethTxSigsCache.computeIfAbsent(hydratedEthTxData.ethTxDataOrThrow());
            return Key.newBuilder().ecdsaSecp256k1(Bytes.wrap((byte[])ethTxSigs.publicKey())).build();
        }
        return null;
    }

    @Provides
    @TransactionScope
    public static EvmActionTracer provideEvmActionTracer() {
        return new EvmActionTracer(new ActionStack());
    }

    @Provides
    @TransactionScope
    public static HederaEvmContext provideHederaEvmContext(@NonNull HandleContext context, @NonNull TinybarValues tinybarValues, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaOperations hederaOperations, @NonNull HederaEvmBlocks hederaEvmBlocks, @NonNull PendingCreationMetadataRef pendingCreationMetadataRef) {
        return new HederaEvmContext(hederaOperations.gasPriceInTinybars(), false, hederaEvmBlocks, tinybarValues, systemContractGasCalculator, (ContractOperationStreamBuilder)context.savepointStack().getBaseBuilder(ContractOperationStreamBuilder.class), pendingCreationMetadataRef);
    }

    @Provides
    @TransactionScope
    public static AttributeValidator provideAttributeValidator(@NonNull HandleContext context) {
        return context.attributeValidator();
    }

    @Provides
    @TransactionScope
    public static ExpiryValidator provideExpiryValidator(@NonNull HandleContext context) {
        return context.expiryValidator();
    }

    @Provides
    @TransactionScope
    public static NetworkInfo provideNetworkInfo(@NonNull HandleContext context) {
        return context.networkInfo();
    }

    @Provides
    @TransactionScope
    public static HederaWorldUpdater.Enhancement provideEnhancement(@NonNull HederaOperations operations, @NonNull HederaNativeOperations nativeOperations, @NonNull SystemContractOperations systemContractOperations) {
        Objects.requireNonNull(operations);
        Objects.requireNonNull(nativeOperations);
        Objects.requireNonNull(systemContractOperations);
        return new HederaWorldUpdater.Enhancement(operations.begin(), nativeOperations, systemContractOperations);
    }

    @Binds
    @TransactionScope
    public EvmFrameStateFactory bindEvmFrameStateFactory(ScopedEvmFrameStateFactory var1);

    @Binds
    @TransactionScope
    public HederaOperations bindHederaOperations(HandleHederaOperations var1);

    @Binds
    @TransactionScope
    public HederaNativeOperations bindHederaNativeOperations(HandleHederaNativeOperations var1);

    @Binds
    @TransactionScope
    public SystemContractOperations bindSystemContractOperations(HandleSystemContractOperations var1);

    @Binds
    @TransactionScope
    public HederaEvmBlocks bindHederaEvmBlocks(HandleContextHevmBlocks var1);
}

