/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulenative;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.schedulenative.ScheduleNativeCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallFactory;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.CreateCommons;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateCommons;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

@Singleton
public class ScheduleNativeTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    public static final SystemContractMethod SCHEDULED_NATIVE_CALL = SystemContractMethod.declare("scheduleNative(address,bytes,address)", "(int64,address)").withCategories(SystemContractMethod.Category.SCHEDULE);
    private static final int SCHEDULE_CONTRACT_ADDRESS = 0;
    private static final int SCHEDULE_CALL_DATA = 1;
    private static final int SCHEDULE_PAYER = 2;
    private final HtsCallFactory htsCallFactory;

    @Inject
    public ScheduleNativeTranslator(@NonNull HtsCallFactory htsCallFactory, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(SCHEDULED_NATIVE_CALL);
        Objects.requireNonNull(htsCallFactory);
        this.htsCallFactory = htsCallFactory;
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        boolean scheduleNativeEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractScheduleNativeEnabled();
        if (!attempt.isSelectorIfConfigEnabled(scheduleNativeEnabled, SCHEDULED_NATIVE_CALL)) {
            return Optional.empty();
        }
        if (!this.innerCallValidation(attempt)) {
            return Optional.empty();
        }
        return Optional.of(SCHEDULED_NATIVE_CALL);
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        Tuple call = SCHEDULED_NATIVE_CALL.decodeCall(attempt.inputBytes());
        Bytes innerCallData = Bytes.wrap((byte[])((byte[])call.get(1)));
        AccountID payerID = attempt.addressIdConverter().convert((com.esaulpaugh.headlong.abi.Address)call.get(2));
        return new ScheduleNativeCall(attempt.systemContractID(), attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.defaultVerificationStrategy(), payerID, ScheduleNativeTranslator::gasRequirement, attempt.keySetFor(), innerCallData, this.htsCallFactory, false);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.SCHEDULE_CREATE, payerId);
    }

    private boolean innerCallValidation(@NonNull HssCallAttempt attempt) {
        Tuple call = SCHEDULED_NATIVE_CALL.decodeCall(attempt.inputBytes());
        com.esaulpaugh.headlong.abi.Address contractAddress = (com.esaulpaugh.headlong.abi.Address)call.get(0);
        com.esaulpaugh.headlong.abi.Address payerAddress = (com.esaulpaugh.headlong.abi.Address)call.get(2);
        AccountID payerID = attempt.addressIdConverter().convert(payerAddress);
        HandleException.validateTrue((payerID != AccountID.DEFAULT ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        Address besuContractAddress = Address.fromHexString((String)contractAddress.toString());
        HandleException.validateTrue((boolean)besuContractAddress.equals((Object)Address.fromHexString((String)"0x167")), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
        byte[] innerCallSelector = Bytes.wrap((byte[])((byte[])call.get(1))).slice(0, 4).toArray();
        boolean canBeCreateToken = CreateCommons.createMethodsSet.stream().anyMatch(s -> Arrays.equals(s.selector(), innerCallSelector));
        boolean canBeUpdateToken = UpdateCommons.updateMethodsSet.stream().anyMatch(s -> Arrays.equals(s.selector(), innerCallSelector));
        return canBeCreateToken || canBeUpdateToken;
    }
}

