/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport.api;

import com.hedera.common.nativesupport.api.ExternalAPI;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamAPI
implements ExternalAPI {
    protected abstract OutputStream getOutputStream();

    protected abstract InputStream getInputStream();

    @Override
    public void sendArray(byte[] array) throws IOException {
        OutputStream os = this.getOutputStream();
        os.write(StreamAPI.intToArray(array.length));
        os.flush();
        os.write(array);
        os.flush();
    }

    @Override
    public byte[] receiveArray() throws IOException {
        InputStream is = this.getInputStream();
        byte[] lenBytes = is.readNBytes(4);
        if (lenBytes.length != 4) {
            throw new EOFException("Expected 4 bytes in length array, got " + lenBytes.length);
        }
        int len = StreamAPI.arrayToInt(lenBytes);
        byte[] output = is.readNBytes(len);
        if (output.length != len) {
            throw new EOFException("Expected " + len + " bytes in data array, got " + output.length);
        }
        return output;
    }

    private static byte[] intToArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private static int arrayToInt(byte[] array) {
        return (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | (array[3] & 0xFF) << 0;
    }
}

