/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public record Fees(long nodeFee, long networkFee, long serviceFee) {
    public static final Fees FREE = new Fees(0L, 0L, 0L);
    public static final FeeData CONSTANT_FEE_DATA = FeeData.newBuilder().setNodedata(FeeComponents.newBuilder().setConstant(1L).build()).setNetworkdata(FeeComponents.newBuilder().setConstant(1L).build()).setServicedata(FeeComponents.newBuilder().setConstant(1L).build()).build();

    public Fees {
        if (nodeFee < 0L) {
            throw new IllegalArgumentException("Node fees must be non-negative");
        }
        if (networkFee < 0L) {
            throw new IllegalArgumentException("Network fees must be non-negative");
        }
        if (serviceFee < 0L) {
            throw new IllegalArgumentException("Service fees must be non-negative");
        }
    }

    public boolean nothingToCharge() {
        return this.nodeFee == 0L && this.networkFee == 0L && this.serviceFee == 0L;
    }

    public Fees withoutServiceComponent() {
        return new Fees(this.nodeFee, this.networkFee, 0L);
    }

    public Fees withChargedNodeComponent(long fee) {
        return new Fees(fee, this.networkFee, this.serviceFee);
    }

    public Fees onlyServiceComponent() {
        return new Fees(0L, 0L, this.serviceFee);
    }

    public long totalFee() {
        return Math.addExact(this.totalWithoutServiceFee(), this.serviceFee);
    }

    public long totalWithoutServiceFee() {
        return Math.addExact(this.nodeFee, this.networkFee);
    }

    public long totalWithoutNodeFee() {
        return Math.addExact(this.networkFee, this.serviceFee);
    }

    public Builder copyBuilder() {
        return new Builder().nodeFee(this.nodeFee).networkFee(this.networkFee).serviceFee(this.serviceFee);
    }

    public Fees plus(@NonNull Fees fees) {
        Objects.requireNonNull(fees);
        return new Fees(this.nodeFee + fees.nodeFee(), this.networkFee + fees.networkFee(), this.serviceFee + fees.serviceFee());
    }

    public static final class Builder {
        private long nodeFee;
        private long networkFee;
        private long serviceFee;

        public Builder nodeFee(long nodeFee) {
            if (nodeFee < 0L) {
                throw new IllegalArgumentException("Node fees must be non-negative");
            }
            this.nodeFee = nodeFee;
            return this;
        }

        public Builder networkFee(long networkFee) {
            if (networkFee < 0L) {
                throw new IllegalArgumentException("Network fees must be non-negative");
            }
            this.networkFee = networkFee;
            return this;
        }

        public Builder serviceFee(long serviceFee) {
            if (serviceFee < 0L) {
                throw new IllegalArgumentException("Service fees must be non-negative");
            }
            this.serviceFee = serviceFee;
            return this;
        }

        public Fees build() {
            return new Fees(this.nodeFee, this.networkFee, this.serviceFee);
        }
    }
}

