/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ExtCodeHashOperation
extends AbstractOperation {
    public ExtCodeHashOperation(GasCalculator gasCalculator) {
        super(63, "EXTCODEHASH", 1, 1, gasCalculator);
    }

    protected long cost(boolean accountIsWarm) {
        return this.gasCalculator().extCodeHashOperationGasCost() + (accountIsWarm ? this.gasCalculator().getWarmStorageReadCost() : this.gasCalculator().getColdAccountAccessCost());
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            Address address = Words.toAddress(frame.popStackItem());
            boolean accountIsWarm = frame.warmUpAddress(address) || this.gasCalculator().isPrecompile(address);
            long cost = this.cost(accountIsWarm);
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Account account = frame.getWorldUpdater().get(address);
            if (account == null || account.isEmpty()) {
                frame.pushStackItem(Bytes.EMPTY);
            } else {
                frame.pushStackItem((Bytes)account.getCodeHash());
            }
            return new Operation.OperationResult(cost, null);
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

