/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.schemas;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public class V0490TokenSchema
extends Schema {
    private static final long MAX_STAKING_INFOS = 1000L;
    private static final long MAX_TOKENS = 1000000L;
    private static final long MAX_ACCOUNTS = 1000000L;
    private static final long MAX_TOKEN_RELS = 1000000L;
    private static final long MAX_MINTABLE_NFTS = 1000000L;
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();
    public static final String NFTS_KEY = "NFTS";
    public static final String TOKENS_KEY = "TOKENS";
    public static final String ALIASES_KEY = "ALIASES";
    public static final String ACCOUNTS_KEY = "ACCOUNTS";
    public static final String TOKEN_RELS_KEY = "TOKEN_RELS";
    public static final String STAKING_INFO_KEY = "STAKING_INFOS";
    public static final String STAKING_NETWORK_REWARDS_KEY = "STAKING_NETWORK_REWARDS";

    public V0490TokenSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.onDisk((String)TOKENS_KEY, (Codec)TokenID.PROTOBUF, (Codec)Token.PROTOBUF, (long)1000000L), StateDefinition.onDisk((String)ACCOUNTS_KEY, (Codec)AccountID.PROTOBUF, (Codec)Account.PROTOBUF, (long)1000000L), StateDefinition.onDisk((String)ALIASES_KEY, (Codec)ProtoBytes.PROTOBUF, (Codec)AccountID.PROTOBUF, (long)1000000L), StateDefinition.onDisk((String)NFTS_KEY, (Codec)NftID.PROTOBUF, (Codec)Nft.PROTOBUF, (long)1000000L), StateDefinition.onDisk((String)TOKEN_RELS_KEY, (Codec)EntityIDPair.PROTOBUF, (Codec)TokenRelation.PROTOBUF, (long)1000000L), StateDefinition.onDisk((String)STAKING_INFO_KEY, (Codec)EntityNumber.PROTOBUF, (Codec)StakingNodeInfo.PROTOBUF, (long)1000L), StateDefinition.singleton((String)STAKING_NETWORK_REWARDS_KEY, (Codec)NetworkStakingRewards.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        if (ctx.isGenesis()) {
            WritableSingletonState networkRewardsState = ctx.newStates().getSingleton(STAKING_NETWORK_REWARDS_KEY);
            NetworkStakingRewards networkRewards = NetworkStakingRewards.newBuilder().pendingRewards(0L).totalStakedRewardStart(0L).totalStakedStart(0L).stakingRewardsActivated(true).build();
            networkRewardsState.put((Object)networkRewards);
        }
    }
}

