/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.account;

import java.util.NavigableMap;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.AccountStorageEntry;

public interface AccountState {
    public Hash getAddressHash();

    public long getNonce();

    public Wei getBalance();

    public Bytes getCode();

    public Hash getCodeHash();

    default public boolean hasCode() {
        return !this.getCode().isEmpty();
    }

    public UInt256 getStorageValue(UInt256 var1);

    public UInt256 getOriginalStorageValue(UInt256 var1);

    default public boolean isEmpty() {
        return this.getNonce() == 0L && this.getBalance().isZero() && !this.hasCode();
    }

    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 var1, int var2);
}

