/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ReturnOperation
extends AbstractOperation {
    public static final int OPCODE = 243;

    public ReturnOperation(GasCalculator gasCalculator) {
        super(243, "RETURN", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long from = Words.clampedToLong(frame.popStackItem());
        long length = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().memoryExpansionGasCost(frame, from, length);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.setOutputData(frame.readMemory(from, length));
        frame.setState(MessageFrame.State.CODE_SUCCESS);
        return new Operation.OperationResult(cost, null);
    }
}

