/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl.handlers;

import com.hedera.hapi.node.addressbook.NodeDeleteTransactionBody;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.addressbook.AddressBookHelper;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.addressbook.impl.WritableNodeStore;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.AccountsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NodeDeleteHandler
implements TransactionHandler {
    @Inject
    public NodeDeleteHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        NodeDeleteTransactionBody op = txn.nodeDeleteOrThrow();
        long nodeId = op.nodeId();
        PreCheckException.validateFalsePreCheck((nodeId < 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        NodeDeleteTransactionBody op = context.body().nodeDeleteOrThrow();
        AccountsConfig accountConfig = (AccountsConfig)context.configuration().getConfigData(AccountsConfig.class);
        ReadableNodeStore nodeStore = (ReadableNodeStore)context.createStore(ReadableNodeStore.class);
        Long payerNum = context.payer().accountNum();
        Node existingNode = nodeStore.get(op.nodeId());
        PreCheckException.validateFalsePreCheck((existingNode == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        PreCheckException.validateFalsePreCheck((boolean)existingNode.deleted(), (ResponseCodeEnum)ResponseCodeEnum.NODE_DELETED);
        if (payerNum.longValue() != accountConfig.treasury() && payerNum.longValue() != accountConfig.systemAdmin() && payerNum.longValue() != accountConfig.addressBookAdmin()) {
            context.requireKeyOrThrow(existingNode.adminKey(), ResponseCodeEnum.INVALID_ADMIN_KEY);
        }
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        NodeDeleteTransactionBody transactionBody = context.body().nodeDeleteOrThrow();
        long nodeId = transactionBody.nodeId();
        WritableNodeStore nodeStore = (WritableNodeStore)context.storeFactory().writableStore(WritableNodeStore.class);
        Node node = nodeStore.get(nodeId);
        HandleException.validateFalse((node == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NODE_ID);
        HandleException.validateFalse((boolean)node.deleted(), (ResponseCodeEnum)ResponseCodeEnum.NODE_DELETED);
        Node.Builder nodeBuilder = node.copyBuilder().deleted(true);
        nodeStore.put(nodeBuilder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        AddressBookHelper.checkDABEnabled((FeeContext)feeContext);
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
        return calculator.calculate();
    }
}

