/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Integers;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;

public final class FastHex {
    public static final int CHARS_PER_BYTE = 2;
    public static final int BITS_PER_CHAR = 4;
    private static final short[] ENCODE_TABLE;
    private static final int[] DECODE_TABLE;

    private FastHex() {
    }

    public static String encodeToString(byte ... buffer) {
        return FastHex.encodeToString(buffer, 0, buffer.length);
    }

    public static String encodeToString(byte[] buffer, int offset, int len) {
        byte[] enc = FastHex.encodeToBytes(buffer, offset, len);
        return new String(enc, 0, 0, enc.length);
    }

    public static byte[] encodeToBytes(byte ... buffer) {
        return FastHex.encodeToBytes(buffer, 0, buffer.length);
    }

    public static byte[] encodeToBytes(byte[] buffer, int offset, int len) {
        byte[] bytes = new byte[len * 2];
        FastHex.encodeBytes(buffer, offset, len, bytes, 0);
        return bytes;
    }

    public static void encodeBytes(byte[] buffer, int offset, int len, byte[] dest, int destOff) {
        int end = offset + len;
        int j = destOff;
        while (offset < end) {
            short hexPair = ENCODE_TABLE[buffer[offset] & 0xFF];
            dest[j] = (byte)(hexPair >>> 8);
            dest[j + 1] = (byte)hexPair;
            ++offset;
            j += 2;
        }
    }

    public static byte[] decode(CharSequence hex) {
        return FastHex.decode(hex, 0, hex.length());
    }

    public static byte[] decode(byte[] hexBytes) {
        return FastHex.decode(hexBytes, 0, hexBytes.length);
    }

    public static byte[] decode(CharSequence hex, int offset, int len) {
        return FastHex.decode(offset, len, hex::charAt);
    }

    public static byte[] decode(byte[] hexBytes, int offset, int len) {
        return FastHex.decode(offset, len, o -> hexBytes[o]);
    }

    private static byte[] decode(int offset, int len, IntUnaryOperator extractor) {
        byte[] dest = new byte[FastHex.decodedLength(len)];
        int i = 0;
        while (i < dest.length) {
            dest[i] = (byte)FastHex.decodeByte(extractor, offset);
            ++i;
            offset += 2;
        }
        return dest;
    }

    public static int decodedLength(int encodedLen) {
        if (!Integers.isMultiple(encodedLen, 2)) {
            throw new IllegalArgumentException("len must be a multiple of two");
        }
        return encodedLen / 2;
    }

    private static int decodeByte(IntUnaryOperator extractor, int offset) {
        try {
            int left = DECODE_TABLE[extractor.applyAsInt(offset)];
            int right = DECODE_TABLE[extractor.applyAsInt(++offset)];
            int b = (left << 4) + right;
            if (b < 0) {
                throw new IllegalArgumentException("illegal hex val @ " + (left < 0 ? offset - 1 : offset));
            }
            return b;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("illegal hex val @ " + offset, aioobe);
        }
    }

    static {
        int i;
        ENCODE_TABLE = new short[256];
        byte[] chars = "0123456789abcdef".getBytes(StandardCharsets.US_ASCII);
        for (int i2 = 0; i2 < ENCODE_TABLE.length; ++i2) {
            byte leftChar = chars[(i2 & 0xF0) >>> 4];
            byte rightChar = chars[i2 & 0xF];
            FastHex.ENCODE_TABLE[i2] = (short)(leftChar << 8 | rightChar);
        }
        DECODE_TABLE = new int[256];
        Arrays.fill(DECODE_TABLE, -241);
        for (i = 48; i <= 57; ++i) {
            FastHex.DECODE_TABLE[i] = i - 48 + 0;
        }
        for (i = 65; i <= 70; ++i) {
            FastHex.DECODE_TABLE[i] = i - 65 + 10;
        }
        for (i = 97; i <= 102; ++i) {
            FastHex.DECODE_TABLE[i] = i - 97 + 10;
        }
    }
}

