/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.stack.WritableKVStateStack;
import com.hedera.node.app.workflows.handle.stack.WritableQueueStateStack;
import com.hedera.node.app.workflows.handle.stack.WritableSingletonStateStack;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class WritableStatesStack
implements WritableStates {
    private final SavepointStackImpl stack;
    private final String statesName;

    public WritableStatesStack(@NonNull SavepointStackImpl stack, @NonNull String serviceName) {
        this.stack = Objects.requireNonNull(stack, "stack must not be null");
        this.statesName = Objects.requireNonNull(serviceName, "serviceName must not be null");
    }

    @NonNull
    WritableStates getCurrent() {
        return this.stack.peek().state().getWritableStates(this.statesName);
    }

    @NonNull
    ReadableStates getRoot() {
        return this.stack.rootStates(this.statesName);
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
        return new WritableKVStateStack(this, this.statesName, stateKey);
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(@NonNull String stateKey) {
        return new WritableSingletonStateStack(this, this.statesName, stateKey);
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
        return new WritableQueueStateStack(this, this.statesName, stateKey);
    }

    public boolean contains(@NonNull String stateKey) {
        return this.getCurrent().contains(stateKey);
    }

    @NonNull
    public Set<String> stateKeys() {
        return this.getCurrent().stateKeys();
    }
}

