/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.netty;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.grpc.GrpcServerManager;
import com.hedera.node.app.grpc.impl.netty.DataBufferMarshaller;
import com.hedera.node.app.grpc.impl.netty.GrpcServiceBuilder;
import com.hedera.node.app.grpc.impl.usage.GrpcUsageTracker;
import com.hedera.node.app.services.ServicesRegistry;
import com.hedera.node.app.spi.RpcService;
import com.hedera.node.app.workflows.ingest.IngestWorkflow;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.node.app.workflows.query.annotations.OperatorQueries;
import com.hedera.node.app.workflows.query.annotations.UserQueries;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.GrpcConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.node.config.data.NettyConfig;
import com.hedera.node.config.types.Profile;
import com.hedera.pbj.runtime.RpcMethodDefinition;
import com.hedera.pbj.runtime.RpcServiceDefinition;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class NettyGrpcServerManager
implements GrpcServerManager {
    private static final Logger logger = LogManager.getLogger(NettyGrpcServerManager.class);
    private static final List<String> SUPPORTED_CIPHERS = List.of("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_AES_256_GCM_SHA384");
    private static final List<String> SUPPORTED_PROTOCOLS = List.of("TLSv1.2", "TLSv1.3");
    private final Set<ServerServiceDefinition> services;
    private Set<ServerServiceDefinition> nodeOperatorServices = Collections.emptySet();
    private final ConfigProvider configProvider;
    private Server plainServer;
    private Server tlsServer;
    private Server nodeOperatorServer;
    private final GrpcUsageTracker usageTracker;

    @Inject
    public NettyGrpcServerManager(@NonNull ConfigProvider configProvider, @NonNull ServicesRegistry servicesRegistry, @NonNull IngestWorkflow ingestWorkflow, @UserQueries @NonNull QueryWorkflow userQueryWorkflow, @OperatorQueries @NonNull QueryWorkflow operatorQueryWorkflow, @NonNull Metrics metrics) {
        this.configProvider = Objects.requireNonNull(configProvider);
        Objects.requireNonNull(ingestWorkflow);
        Objects.requireNonNull(userQueryWorkflow);
        Objects.requireNonNull(operatorQueryWorkflow);
        Objects.requireNonNull(metrics);
        Supplier<Stream<RpcServiceDefinition>> rpcServiceDefinitions = () -> servicesRegistry.registrations().stream().map(ServicesRegistry.Registration::service).filter(v -> v instanceof RpcService).map(v -> (RpcService)v).flatMap(s -> s.rpcDefinitions().stream());
        this.services = this.buildServiceDefinitions(rpcServiceDefinitions, m -> true, ingestWorkflow, userQueryWorkflow, metrics);
        GrpcConfig grpcConfig = (GrpcConfig)configProvider.getConfiguration().getConfigData(GrpcConfig.class);
        if (grpcConfig.nodeOperatorPortEnabled()) {
            this.nodeOperatorServices = this.buildServiceDefinitions(rpcServiceDefinitions, m -> Query.class.equals((Object)m.requestType()), ingestWorkflow, operatorQueryWorkflow, metrics);
        }
        this.usageTracker = new GrpcUsageTracker(configProvider);
    }

    @Override
    public int port() {
        return this.plainServer == null || this.plainServer.isTerminated() ? -1 : this.plainServer.getPort();
    }

    @Override
    public int tlsPort() {
        return this.tlsServer == null ? -1 : this.tlsServer.getPort();
    }

    @Override
    public int nodeOperatorPort() {
        return this.nodeOperatorServer == null || this.nodeOperatorServer.isTerminated() ? -1 : this.nodeOperatorServer.getPort();
    }

    @Override
    public boolean isRunning() {
        return this.plainServer != null && !this.plainServer.isShutdown();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            logger.error("Cannot start gRPC servers, they have already been started!");
            throw new IllegalStateException("Server already started");
        }
        logger.info("Starting gRPC servers");
        NettyConfig nettyConfig = (NettyConfig)this.configProvider.getConfiguration().getConfigData(NettyConfig.class);
        int startRetries = nettyConfig.startRetries();
        long startRetryIntervalMs = nettyConfig.startRetryIntervalMs();
        GrpcConfig grpcConfig = (GrpcConfig)this.configProvider.getConfiguration().getConfigData(GrpcConfig.class);
        int port = grpcConfig.port();
        Profile profile = ((HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class)).activeProfile();
        logger.info("Starting gRPC server on port {}", (Object)port);
        NettyServerBuilder nettyBuilder = this.builderFor(port, nettyConfig, profile, false);
        this.plainServer = this.startServerWithRetry(this.services, nettyBuilder, startRetries, startRetryIntervalMs);
        logger.info("gRPC server listening on port {}", (Object)this.plainServer.getPort());
        try {
            int tlsPort = grpcConfig.tlsPort();
            logger.info("Starting TLS gRPC server on port {}", (Object)tlsPort);
            nettyBuilder = this.builderFor(tlsPort, nettyConfig, profile, false);
            this.configureTls(nettyBuilder, nettyConfig);
            this.tlsServer = this.startServerWithRetry(this.services, nettyBuilder, startRetries, startRetryIntervalMs);
            logger.info("TLS gRPC server listening on port {}", (Object)this.tlsServer.getPort());
        }
        catch (FileNotFoundException | SSLException e) {
            this.tlsServer = null;
            logger.warn("Could not start TLS server, will continue without it: {}", (Object)e.getMessage());
        }
        if (grpcConfig.nodeOperatorPortEnabled()) {
            try {
                int nodeOperatorPort = grpcConfig.nodeOperatorPort();
                logger.info("Starting node operator gRPC server on port {}", (Object)nodeOperatorPort);
                nettyBuilder = this.builderFor(nodeOperatorPort, nettyConfig, profile, true);
                this.nodeOperatorServer = this.startServerWithRetry(this.nodeOperatorServices, nettyBuilder, startRetries, startRetryIntervalMs);
                logger.info("Node operator gRPC server listening on port {}", (Object)this.nodeOperatorServer.getPort());
            }
            catch (Exception e) {
                this.nodeOperatorServer = null;
                logger.warn("Could not start node operator gRPC server, will continue without it: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.plainServer != null && !this.plainServer.isTerminated()) {
            logger.info("Shutting down gRPC server on port {}", (Object)this.plainServer.getPort());
            this.terminateServer(this.plainServer);
        } else {
            logger.info("Cannot shut down an already stopped gRPC server");
        }
        if (this.tlsServer != null && !this.tlsServer.isTerminated()) {
            logger.info("Shutting down TLS gRPC server on port {}", (Object)this.tlsServer.getPort());
            this.terminateServer(this.tlsServer);
        } else {
            logger.info("Cannot shut down an already stopped gRPC server");
        }
        if (this.nodeOperatorServer != null && !this.nodeOperatorServer.isTerminated()) {
            logger.info("Shutting down node operator gRPC server on port {}", (Object)this.nodeOperatorServer.getPort());
            this.terminateServer(this.nodeOperatorServer);
        } else {
            logger.info("Cannot shut down an already stopped node operator gRPC server");
        }
    }

    Server startServerWithRetry(@NonNull Iterable<ServerServiceDefinition> serviceDefinitions, @NonNull NettyServerBuilder nettyBuilder, int startRetries, long startRetryIntervalMs) {
        Objects.requireNonNull(serviceDefinitions);
        Objects.requireNonNull(nettyBuilder);
        serviceDefinitions.forEach(arg_0 -> ((NettyServerBuilder)nettyBuilder).addService(arg_0));
        Server server = nettyBuilder.build();
        int remaining = startRetries;
        while (remaining > 0) {
            try {
                server.start();
                return server;
            }
            catch (IOException e) {
                if (--remaining == 0) {
                    throw new RuntimeException("Failed to start gRPC server");
                }
                logger.info("Still trying to start server... {} tries remaining", (Object)remaining, (Object)e);
                try {
                    Thread.sleep(startRetryIntervalMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while waiting to retry server start", ie);
                }
            }
        }
        throw new RuntimeException("Failed to start gRPC server");
    }

    private void terminateServer(@Nullable Server server) {
        if (server == null) {
            return;
        }
        NettyConfig nettyConfig = (NettyConfig)this.configProvider.getConfiguration().getConfigData(NettyConfig.class);
        long terminationTimeout = nettyConfig.terminationTimeout();
        try {
            server.shutdownNow();
            server.awaitTermination(terminationTimeout, TimeUnit.SECONDS);
            logger.info("gRPC server stopped");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn("Interrupted while waiting for gRPC to terminate!", (Throwable)ie);
        }
        catch (Exception e) {
            logger.warn("Exception while waiting for gRPC to terminate!", (Throwable)e);
        }
    }

    private NettyServerBuilder builderFor(int port, @NonNull NettyConfig config, @NonNull Profile activeProfile, boolean localHostOnly) {
        NettyServerBuilder builder = null;
        try {
            builder = this.withConfigForActiveProfile(NettyGrpcServerManager.getInitialServerBuilder(port, localHostOnly), config, activeProfile).channelType(EpollServerSocketChannel.class).bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
            logger.info("Using Epoll for gRPC server");
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError ignored) {
            logger.info("Epoll not available, using NIO");
            builder = this.withConfigForActiveProfile(NettyGrpcServerManager.getInitialServerBuilder(port, localHostOnly), config, activeProfile);
        }
        catch (Exception unexpected) {
            logger.info("Unexpected exception initializing Netty", (Throwable)unexpected);
        }
        if (builder != null) {
            builder.intercept((ServerInterceptor)this.usageTracker);
        }
        return builder;
    }

    @NonNull
    private static NettyServerBuilder getInitialServerBuilder(int port, boolean localHostOnly) {
        if (localHostOnly) {
            return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress("localhost", port));
        }
        return NettyServerBuilder.forPort((int)port);
    }

    private NettyServerBuilder withConfigForActiveProfile(@NonNull NettyServerBuilder builder, @NonNull NettyConfig config, @NonNull Profile activeProfile) {
        if (activeProfile != Profile.DEV) {
            builder.keepAliveTime(config.prodKeepAliveTime(), TimeUnit.SECONDS).permitKeepAliveTime(config.prodKeepAliveTime(), TimeUnit.SECONDS).keepAliveTimeout(config.prodKeepAliveTimeout(), TimeUnit.SECONDS).maxConnectionAge(config.prodMaxConnectionAge(), TimeUnit.SECONDS).maxConnectionAgeGrace(config.prodMaxConnectionAgeGrace(), TimeUnit.SECONDS).maxConnectionIdle(config.prodMaxConnectionIdle(), TimeUnit.SECONDS).maxConcurrentCallsPerConnection(config.prodMaxConcurrentCalls()).flowControlWindow(config.prodFlowControlWindow());
        }
        return (NettyServerBuilder)builder.directExecutor();
    }

    private void configureTls(NettyServerBuilder builder, NettyConfig config) throws SSLException, FileNotFoundException {
        String tlsCrtPath = config.tlsCrtPath();
        File crt = new File(tlsCrtPath);
        if (!crt.exists()) {
            logger.warn("Specified TLS cert '{}' doesn't exist!", (Object)tlsCrtPath);
            throw new FileNotFoundException(tlsCrtPath);
        }
        String tlsKeyPath = config.tlsKeyPath();
        File key = new File(tlsKeyPath);
        if (!key.exists()) {
            logger.warn("Specified TLS key '{}' doesn't exist!", (Object)tlsKeyPath);
            throw new FileNotFoundException(tlsKeyPath);
        }
        SslContext sslContext = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forServer((File)crt, (File)key)).protocols(SUPPORTED_PROTOCOLS).ciphers(SUPPORTED_CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
        builder.sslContext(sslContext);
    }

    private Set<ServerServiceDefinition> buildServiceDefinitions(@NonNull Supplier<Stream<RpcServiceDefinition>> rpcServiceDefinitions, @NonNull Predicate<RpcMethodDefinition> methodFilter, @NonNull IngestWorkflow ingestWorkflow, @NonNull QueryWorkflow queryWorkflow, @NonNull Metrics metrics) {
        int maxTxnSize = ((HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class)).transactionMaxBytes();
        boolean isJumboEnabled = ((JumboTransactionsConfig)this.configProvider.getConfiguration().getConfigData(JumboTransactionsConfig.class)).isEnabled();
        int jumboMaxTxnSize = isJumboEnabled ? ((JumboTransactionsConfig)this.configProvider.getConfiguration().getConfigData(JumboTransactionsConfig.class)).maxTxnSize() : maxTxnSize;
        int bufferCapacity = isJumboEnabled ? jumboMaxTxnSize + 1 : maxTxnSize + 1;
        DataBufferMarshaller dataBufferMarshaller = new DataBufferMarshaller(bufferCapacity, maxTxnSize);
        DataBufferMarshaller jumboBufferMarshaller = new DataBufferMarshaller(bufferCapacity, jumboMaxTxnSize);
        return rpcServiceDefinitions.get().map(d -> {
            GrpcServiceBuilder builder = new GrpcServiceBuilder(d.basePath(), ingestWorkflow, queryWorkflow, dataBufferMarshaller, jumboBufferMarshaller);
            d.methods().stream().filter(methodFilter).forEach(m -> {
                if (Transaction.class.equals((Object)m.requestType())) {
                    builder.transaction(m.path());
                } else {
                    builder.query(m.path());
                }
            });
            return builder.build(metrics, this.configProvider);
        }).collect(Collectors.toUnmodifiableSet());
    }
}

