/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class WritableSingletonStateStack<T>
implements WritableSingletonState<T> {
    private final WritableStatesStack writableStatesStack;
    private final String serviceName;
    private final String stateKey;

    public WritableSingletonStateStack(@NonNull WritableStatesStack writableStatesStack, @NonNull String serviceName, @NonNull String stateKey) {
        this.writableStatesStack = Objects.requireNonNull(writableStatesStack, "writableStatesStack must not be null");
        this.serviceName = Objects.requireNonNull(serviceName, "serviceName must not be null");
        this.stateKey = Objects.requireNonNull(stateKey, "stateKey must not be null");
    }

    @NonNull
    private WritableSingletonState<T> getCurrent() {
        return this.writableStatesStack.getCurrent().getSingleton(this.stateKey);
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NonNull
    public String getStateKey() {
        return this.stateKey;
    }

    @Nullable
    public T get() {
        return (T)this.getCurrent().get();
    }

    public boolean isRead() {
        return this.getCurrent().isRead();
    }

    public void put(@Nullable T value) {
        this.getCurrent().put(value);
    }

    public boolean isModified() {
        return this.getCurrent().isModified();
    }
}

