/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RLPSequenceIterator
implements Iterator<RLPItem> {
    final RLPDecoder decoder;
    byte[] buffer;
    int index;
    RLPItem next;

    RLPSequenceIterator(RLPDecoder decoder, byte[] buffer, int index) {
        this.decoder = decoder;
        this.buffer = buffer;
        this.index = index;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.index < this.buffer.length) {
            this.next = this.decoder.wrap(this.buffer, this.index);
            return true;
        }
        return false;
    }

    @Override
    public RLPItem next() {
        if (this.hasNext()) {
            RLPItem item = this.next;
            this.next = null;
            this.index = item.endIndex;
            return item;
        }
        throw new NoSuchElementException();
    }

    protected final void finalize() throws Throwable {
    }
}

