/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval.SetApprovalForAllCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval.SetApprovalForAllDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SetApprovalForAllTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod SET_APPROVAL_FOR_ALL = SystemContractMethod.declare("setApprovalForAll(address,address,bool)", "(int)").withCategory(SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod ERC721_SET_APPROVAL_FOR_ALL = SystemContractMethod.declare("setApprovalForAll(address,bool)", "(int)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.APPROVAL);
    private final SetApprovalForAllDecoder decoder;

    @Inject
    public SetApprovalForAllTranslator(SetApprovalForAllDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(SET_APPROVAL_FOR_ALL, ERC721_SET_APPROVAL_FOR_ALL);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        return attempt.isRedirect() ? attempt.isMethod(ERC721_SET_APPROVAL_FOR_ALL) : attempt.isMethod(SET_APPROVAL_FOR_ALL);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        TransactionBody result = this.bodyForClassic(attempt);
        return new SetApprovalForAllCall(attempt, result, SetApprovalForAllTranslator::gasRequirement, attempt.isSelector(ERC721_SET_APPROVAL_FOR_ALL));
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.APPROVE, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(SET_APPROVAL_FOR_ALL)) {
            return this.decoder.decodeSetApprovalForAll(attempt);
        }
        return this.decoder.decodeSetApprovalForAllERC(attempt);
    }
}

