/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.annotations.VisibleForTesting;
import org.hyperledger.besu.crypto.SignatureAlgorithm;
import org.hyperledger.besu.crypto.SignatureAlgorithmType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureAlgorithmFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureAlgorithmFactory.class);
    private static SignatureAlgorithm instance = null;

    private SignatureAlgorithmFactory() {
    }

    public static void setDefaultInstance() {
        instance = SignatureAlgorithmType.createDefault().getInstance();
    }

    public static void setInstance(SignatureAlgorithmType signatureAlgorithmType) throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Instance of SignatureAlgorithmFactory can only be set once.");
        }
        instance = signatureAlgorithmType.getInstance();
        if (!SignatureAlgorithmType.isDefault(instance)) {
            LOG.info("The signature algorithm uses the elliptic curve " + instance.getCurveName() + ". The usage of alternative elliptic curves is still experimental.");
        }
    }

    public static SignatureAlgorithm getInstance() {
        return instance != null ? instance : SignatureAlgorithmType.DEFAULT_SIGNATURE_ALGORITHM_TYPE.get();
    }

    public static boolean isInstanceSet() {
        return instance != null;
    }

    @VisibleForTesting
    public static void resetInstance() {
        instance = null;
    }
}

