/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.node.app.service.file.impl.ReadableUpgradeFileStoreImpl;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Predicate;

public class WritableUpgradeFileStore
extends ReadableUpgradeFileStoreImpl {
    private final WritableStates states;
    private final WritableKVState<FileID, File> writableUpgradeFileState;
    private static final Predicate<ProtoBytes> TRUE_PREDICATE = new TruePredicate();

    public WritableUpgradeFileStore(@NonNull WritableStates states) {
        super((ReadableStates)states);
        this.states = Objects.requireNonNull(states);
        this.writableUpgradeFileState = Objects.requireNonNull(states.get("FILES"));
    }

    public void add(@NonNull File file) {
        Objects.requireNonNull(file);
        this.writableUpgradeFileState.put((Object)file.fileIdOrThrow(), (Object)file);
    }

    public void addUpgradeContent(@NonNull FileID fileID, Bytes content) {
        WritableQueueState<ProtoBytes> upgradeState = this.getUpgradeState(fileID);
        upgradeState.add((Object)new ProtoBytes(content));
    }

    public void append(@NonNull Bytes bytes, @NonNull FileID fileID) {
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(fileID);
        WritableQueueState<ProtoBytes> upgradeState = this.getUpgradeState(fileID);
        upgradeState.add((Object)new ProtoBytes(bytes));
    }

    public void resetFileContents(@NonNull FileID fileID) {
        WritableQueueState<ProtoBytes> upgradeState = this.getUpgradeState(fileID);
        while (upgradeState.removeIf(TRUE_PREDICATE) != null) {
        }
    }

    @NonNull
    private WritableQueueState<ProtoBytes> getUpgradeState(@NonNull FileID fileID) {
        String stateKey = "UPGRADE_DATA[FileID[shardNum=%d, realmNum=%d, fileNum=%d]]".formatted(fileID.shardNum(), fileID.realmNum(), fileID.fileNum());
        return Objects.requireNonNull(this.states.getQueue(stateKey));
    }

    private static class TruePredicate
    implements Predicate<ProtoBytes> {
        private TruePredicate() {
        }

        @Override
        public boolean test(ProtoBytes file) {
            return true;
        }
    }
}

