/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.exports;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class FileCompressionUtils {
    private FileCompressionUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] readUncompressedFileBytes(String fileLoc) throws IOException {
        try (GZIPInputStream fin = new GZIPInputStream(new FileInputStream(fileLoc));){
            byte[] byArray;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = fin.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IOException("Error reading file " + fileLoc, e);
        }
    }
}

