/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeSection;

public class CodeInvalid
implements Code {
    private final Supplier<Hash> codeHash;
    private final Bytes codeBytes;
    private final String invalidReason;

    public CodeInvalid(Bytes codeBytes, String invalidReason) {
        this.codeBytes = codeBytes;
        this.codeHash = Suppliers.memoize(() -> Hash.hash((Bytes)codeBytes));
        this.invalidReason = invalidReason;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    @Override
    public int getSize() {
        return this.codeBytes.size();
    }

    @Override
    public Bytes getBytes() {
        return this.codeBytes;
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public boolean isJumpDestInvalid(int jumpDestination) {
        return false;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public CodeSection getCodeSection(int section) {
        return null;
    }

    @Override
    public int getCodeSectionCount() {
        return 0;
    }

    @Override
    public int getEofVersion() {
        return -1;
    }
}

