/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.tracing;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.AbstractCallOperation;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;

public class StandardJsonTracer
implements OperationTracer {
    private static final Joiner commaJoiner = Joiner.on((char)',');
    private final PrintWriter out;
    private final boolean showMemory;
    private final boolean showStack;
    private final boolean showReturnData;
    private final boolean showStorage;
    private int pc;
    private int section;
    private List<String> stack;
    private String gas;
    private Bytes memory;
    private int memorySize;
    private int depth;
    private String storageString;

    public StandardJsonTracer(PrintWriter out, boolean showMemory, boolean showStack, boolean showReturnData, boolean showStorage) {
        this.out = out;
        this.showMemory = showMemory;
        this.showStack = showStack;
        this.showReturnData = showReturnData;
        this.showStorage = showStorage;
    }

    public StandardJsonTracer(PrintStream out, boolean showMemory, boolean showStack, boolean showReturnData, boolean showStorage) {
        this(new PrintWriter(out, true, StandardCharsets.UTF_8), showMemory, showStack, showReturnData, showStorage);
    }

    public static String shortNumber(UInt256 number) {
        return number.isZero() ? "0x0" : number.toShortHexString();
    }

    public static String shortNumber(long number) {
        return "0x" + Long.toHexString(number);
    }

    private static String shortBytes(Bytes bytes) {
        return bytes.isZero() ? "0x0" : bytes.toShortHexString();
    }

    @Override
    public void tracePreExecution(MessageFrame messageFrame) {
        WorldUpdater updater;
        MutableAccount account;
        this.stack = new ArrayList<String>(messageFrame.stackSize());
        for (int i = messageFrame.stackSize() - 1; i >= 0; --i) {
            this.stack.add("\"" + StandardJsonTracer.shortBytes(messageFrame.getStackItem(i)) + "\"");
        }
        this.pc = messageFrame.getPC() - messageFrame.getCode().getCodeSection(0).getEntryPoint();
        this.section = messageFrame.getSection();
        this.gas = StandardJsonTracer.shortNumber(messageFrame.getRemainingGas());
        this.memorySize = messageFrame.memoryWordSize() * 32;
        this.memory = this.showMemory && this.memorySize > 0 ? messageFrame.readMemory(0L, (long)messageFrame.memoryWordSize() * 32L) : null;
        this.depth = messageFrame.getMessageStackSize();
        StringBuilder sb = new StringBuilder();
        if (this.showStorage && (account = (updater = messageFrame.getWorldUpdater()).getAccount(messageFrame.getRecipientAddress())) != null && !account.getUpdatedStorage().isEmpty()) {
            boolean[] shownEntry = new boolean[]{false};
            sb.append(",\"storage\":{");
            account.getUpdatedStorage().forEach((k, v) -> {
                if (shownEntry[0]) {
                    sb.append(",");
                } else {
                    shownEntry[0] = true;
                }
                sb.append("\"").append(k.toQuantityHexString()).append("\":\"").append(v.toQuantityHexString()).append("\"");
            });
            sb.append("}");
        }
        this.storageString = sb.toString();
    }

    @Override
    public void tracePostExecution(MessageFrame messageFrame, Operation.OperationResult executeResult) {
        Operation currentOp = messageFrame.getCurrentOperation();
        if (currentOp.isVirtualOperation()) {
            return;
        }
        int opcode = currentOp.getOpcode();
        Bytes returnData = messageFrame.getReturnData();
        long thisGasCost = executeResult.getGasCost();
        if (currentOp instanceof AbstractCallOperation) {
            thisGasCost += messageFrame.getMessageFrameStack().getFirst().getRemainingGas();
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("{");
        sb.append("\"pc\":").append(this.pc).append(",");
        if (this.section > 0) {
            sb.append("\"section\":").append(this.section).append(",");
        }
        sb.append("\"op\":").append(opcode).append(",");
        sb.append("\"gas\":\"").append(this.gas).append("\",");
        sb.append("\"gasCost\":\"").append(StandardJsonTracer.shortNumber(thisGasCost)).append("\",");
        if (this.memory != null) {
            sb.append("\"memory\":\"").append(this.memory.toHexString()).append("\",");
        }
        sb.append("\"memSize\":").append(this.memorySize).append(",");
        if (this.showStack) {
            sb.append("\"stack\":[").append(commaJoiner.join(this.stack)).append("],");
        }
        if (this.showReturnData && !returnData.isEmpty()) {
            sb.append("\"returnData\":\"").append(returnData.toHexString()).append("\",");
        }
        sb.append("\"depth\":").append(this.depth).append(",");
        sb.append("\"refund\":").append(messageFrame.getGasRefund()).append(",");
        sb.append("\"opName\":\"").append(currentOp.getName()).append("\"");
        if (executeResult.getHaltReason() != null) {
            sb.append(",\"error\":\"").append(executeResult.getHaltReason().getDescription()).append("\"");
        } else if (messageFrame.getRevertReason().isPresent()) {
            sb.append(",\"error\":\"").append(StandardJsonTracer.quoteEscape(messageFrame.getRevertReason().orElse(Bytes.EMPTY))).append("\"");
        }
        sb.append(this.storageString).append("}");
        this.out.println(sb);
    }

    private static String quoteEscape(Bytes bytes) {
        StringBuilder result = new StringBuilder(bytes.size());
        for (byte b : bytes.toArrayUnsafe()) {
            int c = Byte.toUnsignedInt(b);
            if (c == 34) {
                result.append("\\\"");
                continue;
            }
            if (c == 92) {
                result.append("\\\\");
                continue;
            }
            if (c == 47) {
                result.append("\\/");
                continue;
            }
            if (c == 8) {
                result.append("\\b");
                continue;
            }
            if (c == 12) {
                result.append("\\f");
                continue;
            }
            if (c == 10) {
                result.append("\\n");
                continue;
            }
            if (c == 13) {
                result.append("\\r");
                continue;
            }
            if (c == 9) {
                result.append("\\t");
                continue;
            }
            if (c <= 31) {
                result.append("\\u");
                result.append(Strings.padStart((String)Integer.toHexString(c), (int)4, (char)'0'));
                continue;
            }
            result.append((char)b);
        }
        return result.toString();
    }

    @Override
    public void tracePrecompileCall(MessageFrame frame, long gasRequirement, Bytes output) {
    }

    @Override
    public void traceAccountCreationResult(MessageFrame frame, Optional<ExceptionalHaltReason> haltReason) {
    }
}

