/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RelativeJumpOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 224;

    public RelativeJumpOperation(GasCalculator gasCalculator) {
        this(224, "RJUMP", 0, 0, gasCalculator, gasCalculator.getBaseTierGasCost());
    }

    protected RelativeJumpOperation(int opcode, String name, int stackItemsConsumed, int stackItemsProduced, GasCalculator gasCalculator, long fixedCost) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator, fixedCost);
    }

    @Override
    protected Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Bytes code = frame.getCode().getBytes();
        int pcPostInstruction = frame.getPC() + 1;
        return new Operation.OperationResult(this.gasCost, null, 2 + Words.readBigEndianI16(pcPostInstruction, code.toArrayUnsafe()) + 1);
    }
}

