/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.gas.TinybarValues;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadataRef;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmBlocks;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.BlockValues;

public record HederaEvmContext(long gasPrice, boolean staticCall, @NonNull HederaEvmBlocks blocks, @NonNull TinybarValues tinybarValues, @NonNull SystemContractGasCalculator systemContractGasCalculator, @Nullable ContractOperationStreamBuilder streamBuilder, @Nullable PendingCreationMetadataRef pendingCreationRecordBuilderReference) {
    public HederaEvmContext {
        Objects.requireNonNull(blocks);
        Objects.requireNonNull(tinybarValues);
        Objects.requireNonNull(systemContractGasCalculator);
        if (streamBuilder != null) {
            Objects.requireNonNull(pendingCreationRecordBuilderReference);
        }
        if (pendingCreationRecordBuilderReference != null) {
            Objects.requireNonNull(streamBuilder);
        }
    }

    public BlockValues blockValuesOf(long gasLimit) {
        return this.blocks.blockValuesOf(gasLimit);
    }

    public boolean isNoopGasContext() {
        return this.staticCall || this.gasPrice == 0L;
    }

    public boolean isTransaction() {
        return this.streamBuilder != null && this.pendingCreationRecordBuilderReference != null;
    }
}

