/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.grpc.ClientUriSupplier;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClientUriSuppliers {

    public static class RandomSupplier
    implements ClientUriSupplier {
        private final ClientUri[] clientUris;
        private final SecureRandom random = new SecureRandom();

        public static RandomSupplier create(ClientUri ... clientUris) {
            return new RandomSupplier(clientUris);
        }

        public static RandomSupplier create(Collection<ClientUri> clientUris) {
            return new RandomSupplier(clientUris.toArray(new ClientUri[0]));
        }

        protected RandomSupplier(ClientUri[] clientUris) {
            this.clientUris = clientUris;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public ClientUri next() {
            return this.clientUris[this.random.nextInt(this.clientUris.length)];
        }
    }

    public static class SingleSupplier
    implements ClientUriSupplier {
        private final ClientUri clientUri;

        public static SingleSupplier create(String clientUri) {
            return new SingleSupplier(ClientUri.create((URI)URI.create(clientUri)));
        }

        public static SingleSupplier create(ClientUri clientUri) {
            return new SingleSupplier(clientUri);
        }

        protected SingleSupplier(ClientUri clientUri) {
            this.clientUri = clientUri;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public ClientUri next() {
            return this.clientUri;
        }
    }

    public static class RoundRobinSupplier
    implements ClientUriSupplier {
        private int next;
        private final ClientUri[] clientUris;

        public static RoundRobinSupplier create(ClientUri ... clientUris) {
            return new RoundRobinSupplier(clientUris);
        }

        public static RoundRobinSupplier create(Collection<ClientUri> clientUris) {
            return new RoundRobinSupplier(clientUris.toArray(new ClientUri[0]));
        }

        protected RoundRobinSupplier(ClientUri[] clientUris) {
            this.clientUris = clientUris;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public ClientUri next() {
            return this.clientUris[this.next++ % this.clientUris.length];
        }
    }

    public static class OrderedSupplier
    implements ClientUriSupplier {
        private final Iterator<ClientUri> clientUris;

        public static OrderedSupplier create(ClientUri ... clientUris) {
            return new OrderedSupplier(List.of(clientUris));
        }

        public static OrderedSupplier create(Collection<ClientUri> clientUris) {
            return new OrderedSupplier(clientUris);
        }

        protected OrderedSupplier(Collection<ClientUri> clientUris) {
            this.clientUris = List.copyOf(clientUris).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.clientUris.hasNext();
        }

        @Override
        public ClientUri next() {
            return this.clientUris.next();
        }
    }
}

