/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.recordcache.TransactionReceiptEntries;
import com.hedera.hapi.node.state.recordcache.TransactionReceiptEntry;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.state.DeduplicationCache;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.state.WorkingStateAccessor;
import com.hedera.node.app.state.recordcache.PartialRecordSource;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.types.StreamMode;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class RecordCacheImpl
implements HederaRecordCache {
    private static final Logger logger = LogManager.getLogger(RecordCacheImpl.class);
    public static final Comparator<TransactionReceiptEntry> TRANSACTION_VALID_START_COMPARATOR = Comparator.comparing(e -> e.transactionIdOrElse(TransactionID.DEFAULT).transactionValidStartOrElse(Timestamp.DEFAULT), HapiUtils.TIMESTAMP_COMPARATOR);
    private static final RecordCache.History EMPTY_HISTORY = new RecordCache.History();
    private static final HistorySource EMPTY_HISTORY_SOURCE = new HistorySource();
    private final NetworkInfo networkInfo;
    private final ConfigProvider configProvider;
    private final DeduplicationCache deduplicationCache;
    private final Map<TransactionID, HistorySource> historySources = new ConcurrentHashMap<TransactionID, HistorySource>();
    private final Map<AccountID, Set<TransactionID>> payerTxnIds = new ConcurrentHashMap<AccountID, Set<TransactionID>>();
    private final List<TransactionReceiptEntry> transactionReceipts = new ArrayList<TransactionReceiptEntry>();

    @Inject
    public RecordCacheImpl(@NonNull DeduplicationCache deduplicationCache, @NonNull WorkingStateAccessor workingStateAccessor, @NonNull ConfigProvider configProvider, @NonNull NetworkInfo networkInfo) {
        this.deduplicationCache = Objects.requireNonNull(deduplicationCache);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        deduplicationCache.clear();
        for (TransactionReceiptEntries roundReceipts : this.getReadableQueue(workingStateAccessor)) {
            for (TransactionReceiptEntry receipt : roundReceipts.entries()) {
                TransactionID txnId = receipt.transactionIdOrThrow();
                TransactionID baseTxnId = txnId.nonce() == 0 ? txnId : txnId.copyBuilder().nonce(0).build();
                deduplicationCache.add(baseTxnId);
                HistorySource historySource = this.historySources.computeIfAbsent(baseTxnId, ignore -> new HistorySource());
                if (!NODE_FAILURES.contains(receipt.status())) {
                    historySource.nodeIds().add(receipt.nodeId());
                }
                if (historySource.recordSources().isEmpty()) {
                    historySource.recordSources().add(new PartialRecordSource());
                }
                ((PartialRecordSource)historySource.recordSources.getFirst()).incorporate(RecordCacheImpl.asTxnRecord(receipt));
                this.payerTxnIds.computeIfAbsent(txnId.accountIDOrThrow(), ignored -> new HashSet()).add(txnId);
            }
        }
    }

    @Override
    public void addRecordSource(long nodeId, @NonNull TransactionID userTxnId, @NonNull HederaRecordCache.DueDiligenceFailure dueDiligenceFailure, @NonNull RecordSource recordSource) {
        Objects.requireNonNull(userTxnId);
        Objects.requireNonNull(recordSource);
        for (RecordSource.IdentifiedReceipt identifiedReceipt : recordSource.identifiedReceipts()) {
            TransactionID txnId = identifiedReceipt.txnId();
            ResponseCodeEnum status = identifiedReceipt.receipt().status();
            this.transactionReceipts.add(new TransactionReceiptEntry(nodeId, txnId, status));
            TransactionID baseTxnId = txnId.nonce() == 0 ? txnId : txnId.copyBuilder().nonce(0).build();
            HistorySource historySource = this.historySources.computeIfAbsent(baseTxnId, ignore -> new HistorySource());
            if (!NODE_FAILURES.contains(status)) {
                historySource.nodeIds().add(nodeId);
            }
            if (!historySource.recordSources().contains(recordSource)) {
                historySource.recordSources.add(recordSource);
            }
            AccountID effectivePayerId = dueDiligenceFailure == HederaRecordCache.DueDiligenceFailure.YES && RecordCache.matchesExceptNonce((TransactionID)txnId, (TransactionID)userTxnId) ? Objects.requireNonNull(this.networkInfo.nodeInfo(nodeId)).accountId() : txnId.accountIDOrThrow();
            this.payerTxnIds.computeIfAbsent(effectivePayerId, ignored -> new HashSet()).add(txnId);
        }
    }

    @Override
    public void resetRoundReceipts() {
        this.transactionReceipts.clear();
    }

    @Override
    public void maybeCommitReceiptsBatch(@NonNull State state, @NonNull Instant consensusNow, @NonNull ImmediateStateChangeListener immediateStateChangeListener, int receiptEntriesBatchSize, @NonNull BlockStreamManager blockStreamManager, @NonNull StreamMode streamMode) {
        if (this.transactionReceipts.size() >= receiptEntriesBatchSize) {
            this.commitReceipts(state, consensusNow, immediateStateChangeListener, blockStreamManager, streamMode);
            this.transactionReceipts.clear();
        }
    }

    @Override
    public void commitReceipts(@NonNull State state, @NonNull Instant consensusNow, @NonNull ImmediateStateChangeListener immediateStateChangeListener, @NonNull BlockStreamManager blockStreamManager, @NonNull StreamMode streamMode) {
        List<StateChange> changes;
        Objects.requireNonNull(state);
        Objects.requireNonNull(consensusNow);
        Objects.requireNonNull(blockStreamManager);
        Objects.requireNonNull(streamMode);
        if (streamMode != StreamMode.RECORDS) {
            immediateStateChangeListener.resetQueueStateChanges();
        }
        WritableStates states = state.getWritableStates("RecordCache");
        WritableQueueState queue = states.getQueue("TransactionReceiptQueue");
        this.purgeExpiredReceiptEntries((WritableQueueState<TransactionReceiptEntries>)queue, consensusNow);
        if (!this.transactionReceipts.isEmpty()) {
            queue.add((Object)new TransactionReceiptEntries(new ArrayList<TransactionReceiptEntry>(this.transactionReceipts)));
        }
        if (states instanceof CommittableWritableStates) {
            CommittableWritableStates committable = (CommittableWritableStates)states;
            committable.commit();
        }
        if (streamMode != StreamMode.RECORDS && !(changes = immediateStateChangeListener.getQueueStateChanges()).isEmpty()) {
            blockStreamManager.writeItem(now -> BlockItem.newBuilder().stateChanges(new StateChanges(now, new ArrayList(changes))).build());
        }
    }

    @Override
    @NonNull
    public HederaRecordCache.DuplicateCheckResult hasDuplicate(@NonNull TransactionID txnId, long nodeId) {
        Objects.requireNonNull(txnId);
        HistorySource historySource = this.historySources.get(txnId);
        if (historySource == null || historySource.nodeIds().isEmpty()) {
            return HederaRecordCache.DuplicateCheckResult.NO_DUPLICATE;
        }
        return historySource.nodeIds().contains(nodeId) ? HederaRecordCache.DuplicateCheckResult.SAME_NODE : HederaRecordCache.DuplicateCheckResult.OTHER_NODE;
    }

    private void purgeExpiredReceiptEntries(@NonNull WritableQueueState<TransactionReceiptEntries> queue, @NonNull Instant consensusTimestamp) {
        TransactionReceiptEntries roundReceipts;
        HederaConfig config = (HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class);
        Timestamp earliestValidStart = new Timestamp(consensusTimestamp.getEpochSecond() - config.transactionMaxValidDuration(), consensusTimestamp.getNano());
        while ((roundReceipts = (TransactionReceiptEntries)queue.peek()) != null) {
            if (roundReceipts.entries().isEmpty()) {
                logger.warn("Unexpected empty round receipts in the queue, removing them");
                queue.poll();
                continue;
            }
            Timestamp latestReceiptValidStart = roundReceipts.entries().stream().max(TRANSACTION_VALID_START_COMPARATOR).map(entry -> entry.transactionIdOrElse(TransactionID.DEFAULT).transactionValidStartOrElse(Timestamp.DEFAULT)).orElseThrow();
            if (!HapiUtils.isBefore((Timestamp)latestReceiptValidStart, (Timestamp)earliestValidStart)) break;
            for (TransactionReceiptEntry receipt : roundReceipts.entries()) {
                TransactionID txnId = receipt.transactionIdOrThrow();
                this.historySources.remove(txnId.nonce() == 0 ? txnId : txnId.copyBuilder().nonce(0).build());
                AccountID payerId = txnId.accountIDOrThrow();
                Set txnIds = this.payerTxnIds.computeIfAbsent(payerId, ignored -> new HashSet());
                if (!txnIds.remove(txnId) && !(txnIds = this.payerTxnIds.computeIfAbsent(payerId = Objects.requireNonNull(this.networkInfo.nodeInfo(receipt.nodeId())).accountId(), ignored -> new HashSet())).remove(txnId) && receipt.status() != ResponseCodeEnum.DUPLICATE_TRANSACTION) {
                    logger.warn("Non-duplicate {} not cached for either payer or submitting node {}", (Object)txnId, (Object)payerId);
                }
                if (!txnIds.isEmpty()) continue;
                this.payerTxnIds.remove(payerId);
            }
            queue.poll();
        }
    }

    @Nullable
    public RecordCache.History getHistory(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        HistorySource historySource = this.historySources.get(txnId);
        return historySource != null ? historySource.historyOf(txnId) : (this.deduplicationCache.contains(txnId) ? EMPTY_HISTORY : null);
    }

    @Nullable
    public RecordCache.ReceiptSource getReceipts(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        HistorySource historySource = this.historySources.get(txnId);
        return historySource != null ? historySource : (this.deduplicationCache.contains(txnId) ? EMPTY_HISTORY_SOURCE : null);
    }

    @NonNull
    public List<TransactionRecord> getRecords(@NonNull AccountID accountID) {
        Set<TransactionID> txnIds = this.payerTxnIds.get(accountID);
        if (txnIds == null) {
            return Collections.emptyList();
        }
        int maxRemaining = ((LedgerConfig)this.configProvider.getConfiguration().getConfigData(LedgerConfig.class)).recordsMaxQueryableByAccount();
        ArrayList<TransactionRecord> records = new ArrayList<TransactionRecord>(maxRemaining);
        try {
            for (TransactionID txnId : txnIds) {
                HistorySource historySource = this.historySources.get(txnId);
                if (historySource == null) continue;
                RecordCache.History history = historySource.historyOf(txnId);
                List sourcedRecords = history.orderedRecords();
                records.addAll(sourcedRecords.size() > maxRemaining ? sourcedRecords.subList(0, maxRemaining) : sourcedRecords);
                if ((maxRemaining -= sourcedRecords.size()) > 0) continue;
                break;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        records.sort((a, b) -> HapiUtils.TIMESTAMP_COMPARATOR.compare(a.consensusTimestampOrElse(Timestamp.DEFAULT), b.consensusTimestampOrElse(Timestamp.DEFAULT)));
        return records;
    }

    private ReadableQueueState<TransactionReceiptEntries> getReadableQueue(WorkingStateAccessor workingStateAccessor) {
        ReadableStates states = Objects.requireNonNull(workingStateAccessor.getState()).getReadableStates("RecordCache");
        return states.getQueue("TransactionReceiptQueue");
    }

    private static TransactionRecord asTxnRecord(TransactionReceiptEntry receipt) {
        return TransactionRecord.newBuilder().receipt(TransactionReceipt.newBuilder().status(receipt.status()).build()).transactionID(receipt.transactionId()).build();
    }

    private record HistorySource(@NonNull Set<Long> nodeIds, @NonNull List<RecordSource> recordSources) implements RecordCache.ReceiptSource
    {
        public HistorySource() {
            this(new HashSet<Long>(), new ArrayList<RecordSource>());
        }

        @NonNull
        public TransactionReceipt priorityReceipt(@NonNull TransactionID txnId) {
            Objects.requireNonNull(txnId);
            if (this.recordSources.isEmpty()) {
                return PENDING_RECEIPT;
            }
            TransactionReceipt firstPriorityReceipt = this.recordSources.getFirst().receiptOf(txnId);
            if (!RecordCache.NODE_FAILURES.contains(firstPriorityReceipt.status())) {
                return firstPriorityReceipt;
            }
            int n = this.recordSources.size();
            for (int i = 1; i < n; ++i) {
                TransactionReceipt nextPriorityReceipt = this.recordSources.get(i).receiptOf(txnId);
                if (RecordCache.NODE_FAILURES.contains(nextPriorityReceipt.status())) continue;
                return nextPriorityReceipt;
            }
            return firstPriorityReceipt;
        }

        @Nullable
        public TransactionReceipt childReceipt(@NonNull TransactionID txnId) {
            Objects.requireNonNull(txnId);
            for (RecordSource source : this.recordSources) {
                try {
                    return source.receiptOf(txnId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            return null;
        }

        @NonNull
        public List<TransactionReceipt> duplicateReceipts(@NonNull TransactionID txnId) {
            Objects.requireNonNull(txnId);
            ArrayList<TransactionReceipt> receipts = new ArrayList<TransactionReceipt>();
            this.recordSources.forEach(source -> receipts.add(source.receiptOf(txnId)));
            receipts.remove(this.priorityReceipt(txnId));
            return receipts;
        }

        @NonNull
        public List<TransactionReceipt> childReceipts(@NonNull TransactionID txnId) {
            Objects.requireNonNull(txnId);
            ArrayList<TransactionReceipt> receipts = new ArrayList<TransactionReceipt>();
            this.recordSources.forEach(source -> receipts.addAll(source.childReceiptsOf(txnId)));
            return receipts;
        }

        RecordCache.History historyOf(@NonNull TransactionID userTxnId) {
            ArrayList duplicateRecords = new ArrayList();
            ArrayList childRecords = new ArrayList();
            for (RecordSource recordSource : this.recordSources) {
                recordSource.forEachTxnRecord(txnRecord -> {
                    TransactionID txnId = txnRecord.transactionIDOrThrow();
                    if (RecordCache.matchesExceptNonce((TransactionID)txnId, (TransactionID)userTxnId)) {
                        List source = txnId.nonce() > 0 ? childRecords : duplicateRecords;
                        source.add(txnRecord);
                    }
                });
            }
            return new RecordCache.History(this.nodeIds, duplicateRecords, childRecords);
        }
    }
}

