/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.WritableScheduleStoreImpl;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleCreateHandler;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.hedera.node.app.spi.throttle.Throttle;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleServiceApiProvider
implements ServiceApiProvider<ScheduleServiceApi> {
    private final ScheduleCreateHandler scheduleCreateHandler;

    @Inject
    public ScheduleServiceApiProvider(@NonNull ScheduleCreateHandler scheduleCreateHandler) {
        this.scheduleCreateHandler = Objects.requireNonNull(scheduleCreateHandler);
    }

    public String serviceName() {
        return "ScheduleService";
    }

    public ScheduleServiceApi newInstance(@NonNull Configuration configuration, @NonNull WritableStates writableStates, @NonNull WritableEntityCounters entityCounters) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(writableStates);
        Objects.requireNonNull(entityCounters);
        return new ScheduleServiceApiImpl(new WritableScheduleStoreImpl(writableStates, entityCounters), (LedgerConfig)configuration.getConfigData(LedgerConfig.class), (SchedulingConfig)configuration.getConfigData(SchedulingConfig.class));
    }

    public class ScheduleServiceApiImpl
    implements ScheduleServiceApi {
        private final WritableScheduleStore scheduleStore;
        private final LedgerConfig ledgerConfig;
        private final SchedulingConfig schedulingConfig;

        public ScheduleServiceApiImpl(@NonNull WritableScheduleStore scheduleStore, @NonNull LedgerConfig ledgerConfig, SchedulingConfig schedulingConfig) {
            this.scheduleStore = Objects.requireNonNull(scheduleStore);
            this.ledgerConfig = Objects.requireNonNull(ledgerConfig);
            this.schedulingConfig = Objects.requireNonNull(schedulingConfig);
        }

        public boolean hasContractCallCapacity(long expiry, @NonNull Instant consensusNow, long gasLimit, @NonNull AccountID payerId) {
            Objects.requireNonNull(payerId);
            Objects.requireNonNull(consensusNow);
            ResponseCodeEnum expiryStatus = ScheduleServiceApiProvider.this.scheduleCreateHandler.checkExpiry(consensusNow, expiry, this.ledgerConfig, this.schedulingConfig);
            if (expiryStatus != ResponseCodeEnum.OK) {
                return false;
            }
            TransactionBody synthBody = TransactionBody.newBuilder().contractCall(ContractCallTransactionBody.newBuilder().gas(gasLimit)).build();
            Optional<Throttle> maybeThrottle = ScheduleServiceApiProvider.this.scheduleCreateHandler.loadThrottle(this.scheduleStore, this.schedulingConfig, expiry);
            return maybeThrottle.map(throttle -> throttle.allow(payerId, synthBody, HederaFunctionality.CONTRACT_CALL, Instant.ofEpochSecond(expiry))).orElse(false);
        }
    }
}

