/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts;

import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.node.app.hapi.utils.ValidationUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.AbstractFullContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hederahashgraph.api.proto.java.ResponseCodeEnum;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class ExchangeRateSystemContract
extends AbstractFullContract
implements HederaSystemContract {
    private static final String PRECOMPILE_NAME = "ExchangeRate";
    private static final BigIntegerType WORD_DECODER = (BigIntegerType)TypeFactory.create((String)"uint256");
    public static final int TO_TINYBARS_SELECTOR = 775749482;
    public static final int TO_TINYCENTS_SELECTOR = 1135116841;
    public static final String EXCHANGE_RATE_SYSTEM_CONTRACT_ADDRESS = "0x168";
    public static final ContractID EXCHANGE_RATE_CONTRACT_ID = ContractID.newBuilder().contractNum(ConversionUtils.numberOfLongZero(Address.fromHexString((String)"0x168"))).build();
    private long gasRequirement;

    @Inject
    public ExchangeRateSystemContract(@NonNull GasCalculator gasCalculator) {
        super(PRECOMPILE_NAME, gasCalculator);
    }

    @Override
    @NonNull
    public FullResult computeFully(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull MessageFrame messageFrame) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(messageFrame);
        try {
            ValidationUtils.validateTrue((input.size() >= 4 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            this.gasRequirement = FrameUtils.contractsConfigOf(messageFrame).precompileExchangeRateGasCost();
            int selector = input.getInt(0);
            BigInteger amount = this.biValueFrom(input);
            ExchangeRate activeRate = FrameUtils.proxyUpdaterFor(messageFrame).currentExchangeRate();
            Bytes result = switch (selector) {
                case 775749482 -> this.padded(ConversionUtils.fromAToB(amount, activeRate.hbarEquiv(), activeRate.centEquiv()));
                case 1135116841 -> this.padded(ConversionUtils.fromAToB(amount, activeRate.centEquiv(), activeRate.hbarEquiv()));
                default -> null;
            };
            Objects.requireNonNull(result);
            return new FullResult(PrecompiledContract.PrecompileContractResult.success((Bytes)result), this.gasRequirement, null);
        }
        catch (Exception e) {
            return new FullResult(PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(ExceptionalHaltReason.INVALID_OPERATION)), this.gasRequirement, null);
        }
    }

    @NonNull
    private BigInteger biValueFrom(@NonNull Bytes input) {
        return (BigInteger)WORD_DECODER.decode(input.slice(4).toArrayUnsafe());
    }

    @NonNull
    private Bytes padded(@NonNull BigInteger result) {
        return Bytes32.leftPad((Bytes)Bytes.wrap((byte[])result.toByteArray()));
    }
}

