/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.HeaderConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

class MapHeaderConsumer
implements HeaderConsumer {
    private final Map<String, List<String>> headers;

    MapHeaderConsumer(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public Iterable<String> keys() {
        return this.headers.keySet();
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.headers.get(key)).map(Collection::stream).flatMap(Stream::findFirst);
    }

    @Override
    public Iterable<String> getAll(String key) {
        return this.headers.getOrDefault(key, List.of());
    }

    @Override
    public boolean contains(String key) {
        return this.headers.containsKey(key);
    }

    @Override
    public void setIfAbsent(String key, String ... values) {
        this.headers.putIfAbsent(key, List.of(values));
    }

    @Override
    public void set(String key, String ... values) {
        this.headers.put(key, List.of(values));
    }
}

