/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;

class BooleanBitSetQueue {
    private final int bitsPerSet;
    private final LinkedList<BitSet> writeBacklog;
    private BitSet writeBitSet;
    private BitSet readBitSet;
    private int writeIndex = 0;
    private int readIndex = 0;

    BooleanBitSetQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("initialCapacity must be positive");
        }
        this.bitsPerSet = capacity;
        this.writeBacklog = new LinkedList();
        this.readBitSet = this.writeBitSet = new BitSet(this.bitsPerSet);
    }

    void add(boolean value) {
        if (this.writeIndex >= this.bitsPerSet) {
            this.writeBitSet = new BitSet(this.bitsPerSet);
            this.writeBacklog.add(this.writeBitSet);
            this.writeIndex = 0;
        }
        this.writeBitSet.set(this.writeIndex++, value);
    }

    boolean remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Cannot remove from an empty queue");
        }
        if (this.readIndex >= this.bitsPerSet) {
            this.readBitSet = this.writeBacklog.remove();
            this.readIndex = 0;
        }
        return this.readBitSet.get(this.readIndex++);
    }

    boolean isEmpty() {
        return this.writeBitSet == this.readBitSet && this.readIndex == this.writeIndex;
    }
}

