/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.common;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.AbstractFullContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallFactory;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SystemContractUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public abstract class AbstractNativeSystemContract
extends AbstractFullContract
implements HederaSystemContract {
    private static final Logger log = LogManager.getLogger(AbstractNativeSystemContract.class);
    public static final int FUNCTION_SELECTOR_LENGTH = 4;
    private final CallFactory callFactory;
    private final ContractMetrics contractMetrics;

    protected AbstractNativeSystemContract(@NonNull String name, @NonNull CallFactory callFactory, @NonNull GasCalculator gasCalculator, @NonNull ContractMetrics contractMetrics) {
        super(name, gasCalculator);
        this.callFactory = Objects.requireNonNull(callFactory);
        this.contractMetrics = Objects.requireNonNull(contractMetrics);
    }

    @Override
    public FullResult computeFully(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull MessageFrame frame) {
        Call call;
        Objects.requireNonNull(input);
        Objects.requireNonNull(frame);
        FrameUtils.CallType callType = this.callTypeOf(frame);
        if (callType == FrameUtils.CallType.UNQUALIFIED_DELEGATE) {
            return FullResult.haltResult(ExceptionalHaltReason.PRECOMPILE_ERROR, frame.getRemainingGas());
        }
        AbstractCallAttempt attempt = null;
        try {
            HandleException.validateTrue((input.size() >= 4 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            attempt = (AbstractCallAttempt)this.callFactory.createCallAttemptFrom(contractID, input, callType, frame);
            call = attempt.asExecutableCall();
            if (call == null) {
                return FullResult.successResult(Bytes.EMPTY, 0L);
            }
            if (frame.isStatic() && !call.allowsStaticFrame()) {
                return FullResult.haltResult(FrameUtils.contractsConfigOf(frame).precompileHtsDefaultGasCost());
            }
        }
        catch (HandleException exception) {
            if (exception.getStatus().equals((Object)ResponseCodeEnum.INVALID_TRANSACTION_BODY)) {
                return FullResult.haltResult(ExceptionalHaltReason.INVALID_OPERATION, frame.getRemainingGas());
            }
            HederaWorldUpdater.Enhancement enhancement = FrameUtils.proxyUpdaterFor(frame).enhancement();
            AbstractNativeSystemContract.externalizeFailure(frame.getRemainingGas(), input, Bytes.EMPTY, Objects.requireNonNull(attempt), exception.getStatus(), enhancement, contractID);
            return FullResult.revertResult(exception.getStatus(), frame.getRemainingGas());
        }
        catch (Exception ignore) {
            return FullResult.haltResult(ExceptionalHaltReason.INVALID_OPERATION, frame.getRemainingGas());
        }
        return this.resultOfExecuting(attempt, call, input, frame, contractID);
    }

    private FullResult resultOfExecuting(@NonNull AbstractCallAttempt<?> attempt, @NonNull Call call, @NonNull Bytes input, @NonNull MessageFrame frame, @NonNull ContractID contractID) {
        Call.PricedResult pricedResult;
        try {
            pricedResult = call.execute(frame);
            long gasRequirement = pricedResult.fullResult().gasRequirement();
            boolean insufficientGas = frame.getRemainingGas() < gasRequirement;
            ContractCallStreamBuilder dispatchedRecordBuilder = pricedResult.fullResult().recordBuilder();
            if (dispatchedRecordBuilder != null) {
                if (insufficientGas) {
                    dispatchedRecordBuilder.status(ResponseCodeEnum.INSUFFICIENT_GAS);
                    com.hedera.pbj.runtime.io.buffer.Bytes callData = ConversionUtils.tuweniToPbjBytes(input);
                    dispatchedRecordBuilder.contractCallResult(pricedResult.asResultOfInsufficientGasRemaining(attempt.senderId(), contractID, callData, frame.getRemainingGas())).evmCallTransactionResult(pricedResult.txAsResultOfInsufficientGasRemaining(attempt.senderId(), contractID, callData, frame.getRemainingGas()));
                } else {
                    dispatchedRecordBuilder.contractCallResult(pricedResult.asResultOfCall(attempt.senderId(), contractID, ConversionUtils.tuweniToPbjBytes(input), frame.getRemainingGas())).evmCallTransactionResult(pricedResult.txAsResultOfCall(attempt.senderId(), contractID, ConversionUtils.tuweniToPbjBytes(input), frame.getRemainingGas()));
                }
            } else if (pricedResult.isViewCall()) {
                ResponseCodeEnum status;
                ProxyWorldUpdater proxyWorldUpdater = FrameUtils.proxyUpdaterFor(frame);
                HederaWorldUpdater.Enhancement enhancement = proxyWorldUpdater.enhancement();
                ResponseCodeEnum responseCodeEnum = status = insufficientGas ? ResponseCodeEnum.INSUFFICIENT_GAS : pricedResult.responseCode();
                if (status == ResponseCodeEnum.SUCCESS) {
                    enhancement.systemOperations().externalizeResult(SystemContractUtils.successResultOf(attempt.senderId(), pricedResult.fullResult(), frame, !call.allowsStaticFrame()), pricedResult.responseCode(), enhancement.systemOperations().syntheticSignedTxForNativeCall(input, contractID, true), SystemContractUtils.txSuccessResultOf(attempt.senderId(), pricedResult.fullResult(), frame, !call.allowsStaticFrame()));
                } else {
                    AbstractNativeSystemContract.externalizeFailure(gasRequirement, input, insufficientGas ? Bytes.EMPTY : pricedResult.fullResult().output(), attempt, status, enhancement, contractID);
                }
            }
        }
        catch (HandleException handleException) {
            FullResult fullResult = AbstractNativeSystemContract.haltHandleException(handleException, frame.getRemainingGas());
            this.reportToMetrics(call, fullResult);
            return fullResult;
        }
        catch (Exception internal) {
            log.error("Unhandled failure for input {} to native system contract", (Object)input, (Object)internal);
            FullResult fullResult = FullResult.haltResult(ExceptionalHaltReason.PRECOMPILE_ERROR, frame.getRemainingGas());
            this.reportToMetrics(call, fullResult);
            return fullResult;
        }
        FullResult fullResult = pricedResult.fullResult();
        this.reportToMetrics(call, fullResult);
        return fullResult;
    }

    private void reportToMetrics(@NonNull Call call, @NonNull FullResult fullResult) {
        this.contractMetrics.incrementSystemMethodCall(call.getSystemContractMethod(), fullResult.result().getState());
    }

    private static void externalizeFailure(long gasRequirement, @NonNull Bytes input, @NonNull Bytes output, @NonNull AbstractCallAttempt<?> attempt, @NonNull ResponseCodeEnum status, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull ContractID contractID) {
        enhancement.systemOperations().externalizeResult(SystemContractUtils.contractFunctionResultFailedFor(attempt.senderId(), output, gasRequirement, status.toString(), contractID), status, enhancement.systemOperations().syntheticSignedTxForNativeCall(input, contractID, true), SystemContractUtils.txResultFailedFor(attempt.senderId(), output, gasRequirement, status.toString(), contractID));
    }

    private static FullResult haltHandleException(@NonNull HandleException handleException, long remainingGas) {
        if (handleException.getStatus().equals((Object)ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED)) {
            return FullResult.haltResult(CustomExceptionalHaltReason.INSUFFICIENT_CHILD_RECORDS, remainingGas);
        }
        throw handleException;
    }

    protected abstract FrameUtils.CallType callTypeOf(@NonNull MessageFrame var1);
}

