/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.nfttokeninfo;

import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractNonRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.TokenTupleUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.nfttokeninfo.address_0x16c.NftTokenInfoTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.LedgerConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public class NftTokenInfoCall
extends AbstractNonRevertibleTokenViewCall {
    private final Configuration configuration;
    private final boolean isStaticCall;
    private final long serialNumber;
    private final Function function;

    public NftTokenInfoCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, boolean isStaticCall, @Nullable Token token, long serialNumber, @NonNull Configuration configuration, Function function) {
        super(gasCalculator, enhancement, token);
        this.configuration = Objects.requireNonNull(configuration);
        this.serialNumber = serialNumber;
        this.isStaticCall = isStaticCall;
        this.function = function;
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        Nft nft = this.enhancement.nativeOperations().getNft(token.tokenIdOrElse(ReturnTypes.ZERO_TOKEN_ID), this.serialNumber);
        ResponseCodeEnum status = nft != null ? ResponseCodeEnum.SUCCESS : ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER;
        return Call.PricedResult.gasOnly(this.fullResultsFor(status, this.gasCalculator.viewGasRequirement(), token, nft), status, true);
    }

    @Override
    @NonNull
    protected FullResult viewCallResultWith(@NonNull ResponseCodeEnum status, long gasRequirement) {
        return this.fullResultsFor(status, gasRequirement, Token.DEFAULT, null);
    }

    @NonNull
    private FullResult fullResultsFor(@NonNull ResponseCodeEnum status, long gasRequirement, @NonNull Token token, @Nullable Nft nft) {
        Objects.requireNonNull(status);
        Objects.requireNonNull(token);
        if (this.isStaticCall && (status != ResponseCodeEnum.SUCCESS || nft == null)) {
            return FullResult.revertResult(status, this.gasCalculator.viewGasRequirement());
        }
        Nft nonNullNft = nft != null ? nft : Nft.DEFAULT;
        LedgerConfig ledgerConfig = (LedgerConfig)this.configuration.getConfigData(LedgerConfig.class);
        String ledgerId = Bytes.wrap((byte[])ledgerConfig.id().toByteArray()).toString();
        return this.function.getName().equals(com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.nfttokeninfo.address_0x167.NftTokenInfoTranslator.NON_FUNGIBLE_TOKEN_INFO.methodName()) && this.function.getOutputs().equals(com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.nfttokeninfo.address_0x167.NftTokenInfoTranslator.NON_FUNGIBLE_TOKEN_INFO.getOutputs()) ? FullResult.successResult(com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.nfttokeninfo.address_0x167.NftTokenInfoTranslator.NON_FUNGIBLE_TOKEN_INFO.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)TokenTupleUtils.nftTokenInfoTupleFor(token, nonNullNft, this.serialNumber, ledgerId, this.nativeOperations(), 1))), gasRequirement) : FullResult.successResult(NftTokenInfoTranslator.NON_FUNGIBLE_TOKEN_INFO_16C.getOutputs().encode((Object)Tuple.of((Object)status.protoOrdinal(), (Object)TokenTupleUtils.nftTokenInfoTupleFor(token, nonNullNft, this.serialNumber, ledgerId, this.nativeOperations(), 2))), gasRequirement);
    }
}

