/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.api;

import com.swirlds.logging.api.Level;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public interface Logger {
    default public void error(@NonNull String message) {
        this.log(Level.ERROR, message);
    }

    default public void error(@NonNull String message, @Nullable Throwable throwable) {
        this.log(Level.ERROR, message, throwable);
    }

    default public void error(@NonNull String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    default public void error(@NonNull String message, @Nullable Object arg) {
        this.log(Level.ERROR, message, arg);
    }

    default public void error(@NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.ERROR, message, arg1, arg2);
    }

    default public void error(@NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.log(Level.ERROR, message, throwable, args);
    }

    default public void error(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.log(Level.ERROR, message, throwable, arg1);
    }

    default public void error(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.ERROR, message, throwable, arg1, arg2);
    }

    default public void warn(@NonNull String message) {
        this.log(Level.WARN, message);
    }

    default public void warn(@NonNull String message, @Nullable Throwable throwable) {
        this.log(Level.WARN, message, throwable);
    }

    default public void warn(@NonNull String message, Object ... args) {
        this.log(Level.WARN, message, args);
    }

    default public void warn(@NonNull String message, @Nullable Object arg) {
        this.log(Level.WARN, message, arg);
    }

    default public void warn(@NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.WARN, message, arg1, arg2);
    }

    default public void warn(@NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.log(Level.WARN, message, throwable, args);
    }

    default public void warn(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.log(Level.WARN, message, throwable, arg1);
    }

    default public void warn(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.WARN, message, throwable, arg1, arg2);
    }

    default public void info(@NonNull String message) {
        this.log(Level.INFO, message);
    }

    default public void info(@NonNull String message, @Nullable Throwable throwable) {
        this.log(Level.INFO, message, throwable);
    }

    default public void info(@NonNull String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    default public void info(@NonNull String message, @Nullable Object arg) {
        this.log(Level.INFO, message, arg);
    }

    default public void info(@NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.INFO, message, arg1, arg2);
    }

    default public void info(@NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.log(Level.INFO, message, throwable, args);
    }

    default public void info(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.log(Level.INFO, message, throwable, arg1);
    }

    default public void info(String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.INFO, message, throwable, arg1, arg2);
    }

    default public void debug(@NonNull String message) {
        this.log(Level.DEBUG, message);
    }

    default public void debug(@NonNull String message, @Nullable Throwable throwable) {
        this.log(Level.DEBUG, message, throwable);
    }

    default public void debug(@NonNull String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    default public void debug(@NonNull String message, @Nullable Object arg) {
        this.log(Level.DEBUG, message, arg);
    }

    default public void debug(@NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.DEBUG, message, arg1, arg2);
    }

    default public void debug(@NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.log(Level.DEBUG, message, throwable, args);
    }

    default public void debug(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.log(Level.DEBUG, message, throwable, arg1);
    }

    default public void debug(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.DEBUG, message, throwable, arg1, arg2);
    }

    default public void trace(@NonNull String message) {
        this.log(Level.TRACE, message);
    }

    default public void trace(@NonNull String message, @Nullable Throwable throwable) {
        this.log(Level.TRACE, message, throwable);
    }

    default public void trace(@NonNull String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    default public void trace(@NonNull String message, @Nullable Object arg) {
        this.log(Level.TRACE, message, arg);
    }

    default public void trace(@NonNull String message, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.TRACE, message, arg1, arg2);
    }

    default public void trace(@NonNull String message, @Nullable Throwable throwable, Object ... args) {
        this.log(Level.TRACE, message, throwable, args);
    }

    default public void trace(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1) {
        this.log(Level.TRACE, message, throwable, arg1);
    }

    default public void trace(@NonNull String message, @Nullable Throwable throwable, @Nullable Object arg1, @Nullable Object arg2) {
        this.log(Level.TRACE, message, throwable, arg1, arg2);
    }

    public void log(@NonNull Level var1, @NonNull String var2);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Throwable var3);

    public void log(@NonNull Level var1, @NonNull String var2, Object ... var3);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Object var3);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Object var3, @Nullable Object var4);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Throwable var3, Object ... var4);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Throwable var3, @Nullable Object var4);

    public void log(@NonNull Level var1, @NonNull String var2, @Nullable Throwable var3, @Nullable Object var4, @Nullable Object var5);

    @NonNull
    public Logger withMarker(@NonNull String var1);

    @NonNull
    public Logger withContext(@NonNull String var1, @Nullable String var2);

    @NonNull
    public Logger withContext(@NonNull String var1, String ... var2);

    @NonNull
    default public Logger withContext(@NonNull String key, int value) {
        return this.withContext(key, Integer.toString(value));
    }

    @NonNull
    default public Logger withContext(@NonNull String key, int ... values) {
        if (values == null) {
            return this.withContext(key, (String)null);
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Integer.toString(values[i]);
        }
        return this.withContext(key, stringValues);
    }

    @NonNull
    default public Logger withContext(@NonNull String key, long value) {
        return this.withContext(key, Long.toString(value));
    }

    @NonNull
    default public Logger withContext(@NonNull String key, long ... values) {
        if (values == null) {
            return this.withContext(key, (String)null);
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Long.toString(values[i]);
        }
        return this.withContext(key, stringValues);
    }

    @NonNull
    default public Logger withContext(@NonNull String key, double value) {
        return this.withContext(key, Double.toString(value));
    }

    @NonNull
    default public Logger withContext(@NonNull String key, double ... values) {
        if (values == null) {
            return this.withContext(key, (String)null);
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Double.toString(values[i]);
        }
        return this.withContext(key, stringValues);
    }

    @NonNull
    default public Logger withContext(@NonNull String key, float value) {
        return this.withContext(key, Float.toString(value));
    }

    @NonNull
    default public Logger withContext(@NonNull String key, float ... values) {
        if (values == null) {
            return this.withContext(key, (String)null);
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Float.toString(values[i]);
        }
        return this.withContext(key, stringValues);
    }

    @NonNull
    default public Logger withContext(@NonNull String key, boolean value) {
        return this.withContext(key, Boolean.toString(value));
    }

    @NonNull
    default public Logger withContext(@NonNull String key, boolean ... values) {
        if (values == null) {
            return this.withContext(key, (String)null);
        }
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = Boolean.toString(values[i]);
        }
        return this.withContext(key, stringValues);
    }

    public boolean isEnabled(@NonNull Level var1);

    default public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    default public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    default public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    default public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    default public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    @NonNull
    public String getName();
}

