/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class PushOperation
extends AbstractFixedCostOperation {
    public static final int PUSH_BASE = 95;
    public static final int PUSH_MAX = 127;
    private final int length;
    static final Operation.OperationResult pushSuccess = new Operation.OperationResult(3L, null);

    public PushOperation(int length, GasCalculator gasCalculator) {
        super(95 + length, "PUSH" + length, 0, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
        this.length = length;
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        byte[] code = frame.getCode().getBytes().toArrayUnsafe();
        return PushOperation.staticOperation(frame, code, frame.getPC(), this.length);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, byte[] code, int pc, int pushSize) {
        Bytes push;
        int copyStart = pc + 1;
        if (code.length <= copyStart) {
            push = Bytes.EMPTY;
        } else {
            int copyLength = Math.min(pushSize, code.length - pc - 1);
            push = Bytes.wrap((byte[])code, (int)copyStart, (int)copyLength);
        }
        frame.pushStackItem(push);
        frame.setPC(pc + pushSize);
        return pushSuccess;
    }
}

