/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ScaleFactor;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.schedule.WritableScheduleStore;
import com.hedera.node.app.service.schedule.impl.handlers.AbstractScheduleHandler;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleFeeCharging;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.throttle.Throttle;
import com.hedera.node.app.spi.validation.PreCheckValidator;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ScheduleCreateHandler
extends AbstractScheduleHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(ScheduleCreateHandler.class);
    private final ScheduleOpsUsage scheduleOpsUsage = new ScheduleOpsUsage();
    private final EntityIdFactory idFactory;
    private final InstantSource instantSource;
    private final Throttle.Factory throttleFactory;

    @Inject
    public ScheduleCreateHandler(@NonNull EntityIdFactory idFactory, @NonNull InstantSource instantSource, @NonNull Throttle.Factory throttleFactory, @NonNull ScheduleFeeCharging feeCharging) {
        super(feeCharging);
        this.idFactory = Objects.requireNonNull(idFactory);
        this.instantSource = Objects.requireNonNull(instantSource);
        this.throttleFactory = Objects.requireNonNull(throttleFactory);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        Objects.requireNonNull(body);
        PreCheckException.validateTruePreCheck((boolean)body.hasScheduleCreate(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        ScheduleCreateTransactionBody op = body.scheduleCreateOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasScheduledTransactionBody(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION);
        PreCheckException.validateFalsePreCheck((op.waitForExpiry() && !op.hasExpirationTime() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MISSING_EXPIRY_TIME);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        ScheduleCreateTransactionBody op = body.scheduleCreateOrThrow();
        Configuration config = context.configuration();
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        SchedulableTransactionBody scheduledTxnBody = op.scheduledTransactionBodyOrThrow();
        HederaFunctionality scheduledFunctionality = HandlerUtility.functionalityForType((SchedulableTransactionBody.DataOneOfType)scheduledTxnBody.data().kind());
        PreCheckValidator.checkMemo((String)scheduledTxnBody.memo(), (int)hederaConfig.transactionMaxMemoUtf8Bytes());
        PreCheckValidator.checkMaxCustomFees((List)scheduledTxnBody.maxCustomFees(), (HederaFunctionality)scheduledFunctionality);
        if (op.hasPayerAccountID()) {
            ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
            Account payer = accountStore.getAccountById(op.payerAccountIDOrThrow());
            Validations.mustExist((Object)payer, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST);
        }
        SchedulingConfig schedulingConfig = (SchedulingConfig)config.getConfigData(SchedulingConfig.class);
        PreCheckException.validateTruePreCheck((boolean)this.isAllowedFunction(op.scheduledTransactionBodyOrThrow(), schedulingConfig), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULED_TRANSACTION_NOT_IN_WHITELIST);
        if (op.hasAdminKey()) {
            context.requireKey(op.adminKeyOrThrow());
        }
        LedgerConfig ledgerConfig = (LedgerConfig)config.getConfigData(LedgerConfig.class);
        long defaultLifetime = ledgerConfig.scheduleTxExpiryTimeSecs();
        Schedule schedule = HandlerUtility.createProvisionalSchedule(body, this.instantSource.instant(), defaultLifetime, schedulingConfig.longTermEnabled());
        TransactionKeys transactionKeys = this.getRequiredKeys(schedule, (arg_0, arg_1) -> ((PreHandleContext)context).allKeysForTransaction(arg_0, arg_1));
        if (op.hasPayerAccountID()) {
            context.optionalKey(transactionKeys.payerKey());
        }
        context.optionalKeys(transactionKeys.requiredNonPayerKeys());
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        SchedulingConfig schedulingConfig = (SchedulingConfig)context.configuration().getConfigData(SchedulingConfig.class);
        boolean isLongTermEnabled = schedulingConfig.longTermEnabled();
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        Instant consensusNow = context.consensusNow();
        int defaultLifetime = ledgerConfig.scheduleTxExpiryTimeSecs();
        Schedule provisionalSchedule = HandlerUtility.createProvisionalSchedule(context.body(), consensusNow, defaultLifetime, isLongTermEnabled);
        long then = provisionalSchedule.calculatedExpirationSecond();
        ResponseCodeEnum expiryValidity = this.checkExpiry(consensusNow, then, ledgerConfig, schedulingConfig);
        HandleException.validateTrue((expiryValidity == ResponseCodeEnum.OK ? 1 : 0) != 0, (ResponseCodeEnum)expiryValidity);
        HandleException.validateTrue((boolean)this.isAllowedFunction(provisionalSchedule.scheduledTransactionOrThrow(), schedulingConfig), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULED_TRANSACTION_NOT_IN_WHITELIST);
        context.attributeValidator().validateMemo(provisionalSchedule.memo());
        context.attributeValidator().validateMemo(provisionalSchedule.scheduledTransactionOrThrow().memo());
        if (provisionalSchedule.hasAdminKey()) {
            try {
                context.attributeValidator().validateKey(provisionalSchedule.adminKeyOrThrow());
            }
            catch (HandleException e) {
                throw new HandleException(ResponseCodeEnum.INVALID_ADMIN_KEY);
            }
        }
        ResponseCodeEnum validationResult = this.validate(provisionalSchedule, consensusNow, isLongTermEnabled);
        HandleException.validateTrue((boolean)this.isMaybeExecutable(validationResult), (ResponseCodeEnum)validationResult);
        HandleException.validateFalse((!isLongTermEnabled && provisionalSchedule.providedExpirationSecond() != 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_EXPIRY_NOT_CONFIGURABLE);
        WritableScheduleStore scheduleStore = (WritableScheduleStore)context.storeFactory().writableStore(WritableScheduleStore.class);
        ScheduleID possibleDuplicateId = scheduleStore.getByEquality(provisionalSchedule);
        Schedule possibleDuplicate = possibleDuplicateId == null ? null : scheduleStore.get(possibleDuplicateId);
        Schedule duplicate = this.maybeDuplicate(provisionalSchedule, possibleDuplicate);
        if (duplicate != null) {
            TransactionID scheduledTxnId = HandlerUtility.scheduledTxnIdFrom(duplicate.originalCreateTransactionOrThrow().transactionIDOrThrow());
            ((ScheduleStreamBuilder)context.savepointStack().getBaseBuilder(ScheduleStreamBuilder.class)).scheduleID(duplicate.scheduleId()).scheduledTransactionID(scheduledTxnId);
            throw new HandleException(ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED);
        }
        Optional<Throttle> maybeThrottle = this.loadThrottle(scheduleStore, schedulingConfig, then);
        HandleException.validateTrue((boolean)maybeThrottle.isPresent(), (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        Throttle throttle = maybeThrottle.get();
        HandleException.validateTrue((boolean)throttle.allow(provisionalSchedule.payerAccountIdOrThrow(), HandlerUtility.childAsOrdinary(provisionalSchedule), this.functionOf(provisionalSchedule), Instant.ofEpochSecond(then)), (ResponseCodeEnum)ResponseCodeEnum.SCHEDULE_EXPIRY_IS_BUSY);
        scheduleStore.trackUsage(then, throttle.usageSnapshots());
        TransactionKeys transactionKeys = this.getTransactionKeysOrThrow(provisionalSchedule, (arg_0, arg_1) -> ((HandleContext)context).allKeysForTransaction(arg_0, arg_1));
        List<Key> requiredKeys = this.allRequiredKeys(transactionKeys);
        List<Key> signatories = ScheduleCreateHandler.newSignatories(context.keyVerifier().authorizingSimpleKeys(), Collections.emptyList(), requiredKeys);
        TransactionID schedulingTxnId = provisionalSchedule.originalCreateTransactionOrThrow().transactionIDOrThrow();
        AccountID schedulerId = schedulingTxnId.accountIDOrThrow();
        ScheduleID scheduleId = this.idFactory.newScheduleId(context.entityNumGenerator().newEntityNum());
        Schedule schedule = provisionalSchedule.copyBuilder().scheduleId(scheduleId).schedulerAccountId(schedulerId).signatories(signatories).build();
        if (this.tryToExecuteSchedule(context, schedule, requiredKeys, validationResult, isLongTermEnabled)) {
            schedule = ScheduleCreateHandler.markedExecuted(schedule, consensusNow);
        }
        scheduleStore.putAndIncrementCount(schedule);
        ((ScheduleStreamBuilder)context.savepointStack().getBaseBuilder(ScheduleStreamBuilder.class)).scheduleID(schedule.scheduleId()).scheduledTransactionID(HandlerUtility.transactionIdForScheduled(schedule));
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        Configuration config = feeContext.configuration();
        LedgerConfig ledgerConfig = (LedgerConfig)config.getConfigData(LedgerConfig.class);
        SchedulingConfig schedulingConfig = (SchedulingConfig)config.getConfigData(SchedulingConfig.class);
        SubType subType = body.scheduleCreateOrElse(ScheduleCreateTransactionBody.DEFAULT).scheduledTransactionBodyOrElse(SchedulableTransactionBody.DEFAULT).hasContractCall() ? SubType.SCHEDULE_CREATE_CONTRACT_CALL : SubType.DEFAULT;
        return feeContext.feeCalculatorFactory().feeCalculator(subType).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj, schedulingConfig.longTermEnabled(), ledgerConfig.scheduleTxExpiryTimeSecs()));
    }

    public ResponseCodeEnum checkExpiry(@NonNull Instant consensusNow, long expiry, @NonNull LedgerConfig ledgerConfig, @NonNull SchedulingConfig schedulingConfig) {
        long maxLifetime;
        long now = consensusNow.getEpochSecond();
        if (expiry <= now) {
            return ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME;
        }
        long l = maxLifetime = schedulingConfig.longTermEnabled() ? schedulingConfig.maxExpirationFutureSeconds() : (long)ledgerConfig.scheduleTxExpiryTimeSecs();
        if (expiry > now + maxLifetime) {
            return ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE;
        }
        return ResponseCodeEnum.OK;
    }

    public Optional<Throttle> loadThrottle(@NonNull WritableScheduleStore scheduleStore, @NonNull SchedulingConfig schedulingConfig, long then) {
        Objects.requireNonNull(scheduleStore);
        Objects.requireNonNull(schedulingConfig);
        if (scheduleStore.numSchedulesInState() + 1L > schedulingConfig.maxNumber()) {
            return Optional.empty();
        }
        ScaleFactor capacityFraction = schedulingConfig.schedulableCapacityFraction();
        ThrottleUsageSnapshots usageSnapshots = scheduleStore.usageSnapshotsForScheduled(then);
        return Optional.of(this.upToDateThrottle(then, capacityFraction.asApproxCapacitySplit(), usageSnapshots, scheduleStore));
    }

    @NonNull
    private FeeData usageGiven(@NonNull com.hederahashgraph.api.proto.java.TransactionBody txn, @NonNull SigValueObj svo, boolean longTermEnabled, long scheduledTxExpiryTimeSecs) {
        com.hederahashgraph.api.proto.java.ScheduleCreateTransactionBody op = txn.getScheduleCreate();
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        long lifetimeSecs = op.hasExpirationTime() && longTermEnabled ? Math.max(0L, op.getExpirationTime().getSeconds() - txn.getTransactionID().getTransactionValidStart().getSeconds()) : scheduledTxExpiryTimeSecs;
        return this.scheduleOpsUsage.scheduleCreateUsage(txn, sigUsage, lifetimeSecs);
    }

    @Nullable
    private Schedule maybeDuplicate(@NonNull Schedule schedule, @Nullable Schedule duplicate) {
        if (duplicate == null) {
            return null;
        }
        if (this.areIdentical(duplicate, schedule)) {
            return duplicate;
        }
        return null;
    }

    private boolean areIdentical(@NonNull Schedule candidate, @NonNull Schedule requested) {
        return candidate.waitForExpiry() == requested.waitForExpiry() && candidate.providedExpirationSecond() == requested.providedExpirationSecond() && Objects.equals(candidate.memo(), requested.memo()) && Objects.equals(candidate.adminKey(), requested.adminKey()) && Objects.equals(candidate.scheduledTransaction(), requested.scheduledTransaction());
    }

    private boolean isAllowedFunction(@NonNull SchedulableTransactionBody body, @NonNull SchedulingConfig config) {
        HederaFunctionality scheduledFunctionality = HandlerUtility.functionalityForType((SchedulableTransactionBody.DataOneOfType)body.data().kind());
        return config.whitelist().functionalitySet().contains(scheduledFunctionality);
    }

    private HederaFunctionality functionOf(@NonNull Schedule schedule) {
        return HandlerUtility.functionalityForType((SchedulableTransactionBody.DataOneOfType)schedule.scheduledTransactionOrThrow().data().kind());
    }

    private Throttle upToDateThrottle(long then, int capacitySplit, @Nullable ThrottleUsageSnapshots usageSnapshots, @NonNull WritableScheduleStore scheduleStore) {
        Objects.requireNonNull(scheduleStore);
        try {
            return this.throttleFactory.newThrottle(capacitySplit, usageSnapshots);
        }
        catch (Exception e) {
            Instant instantThen = Instant.ofEpochSecond(then);
            log.info("Could not recreate throttle at {} from {} ({}), rebuilding with up-to-date throttle", (Object)instantThen, (Object)usageSnapshots, (Object)e.getMessage());
            Throttle throttle = this.throttleFactory.newThrottle(capacitySplit, null);
            ScheduledCounts counts = Objects.requireNonNull(scheduleStore.scheduledCountsAt(then));
            int n = counts.numberScheduled();
            for (int i = 0; i < n; ++i) {
                ScheduleID scheduleId = Objects.requireNonNull(scheduleStore.getByOrder(new ScheduledOrder(then, i)));
                Schedule schedule = Objects.requireNonNull(scheduleStore.get(scheduleId));
                throttle.allow(schedule.payerAccountIdOrThrow(), HandlerUtility.childAsOrdinary(schedule), this.functionOf(schedule), Instant.ofEpochSecond(then));
            }
            log.info("Rebuilt throttle at {} from {} scheduled transactions", (Object)instantThen, (Object)n);
            return throttle;
        }
    }
}

