/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.standalone.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NodeAddressBook;
import com.hedera.node.app.info.NodeInfoImpl;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StandaloneNetworkInfo
implements NetworkInfo {
    private static final Logger log = LogManager.getLogger(StandaloneNetworkInfo.class);
    private final Bytes ledgerId;
    private final ConfigProvider configProvider;
    private final NodeInfo selfNodeInfo;
    @Nullable
    private List<NodeInfo> nodeInfos;

    @Inject
    public StandaloneNetworkInfo(@NonNull ConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider);
        VersionedConfiguration config = configProvider.getConfiguration();
        this.ledgerId = ((LedgerConfig)config.getConfigData(LedgerConfig.class)).id();
        this.selfNodeInfo = new NodeInfoImpl(0L, AccountID.DEFAULT, 0L, List.of(), Bytes.EMPTY, List.of(), false, null);
    }

    public void initFrom(@NonNull State state) {
        Objects.requireNonNull(state);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        Bytes nodeDetails = FileUtilities.getFileContent(state, FileUtilities.createFileID(filesConfig.nodeDetails(), (Configuration)config));
        try {
            NodeAddressBook nodeAddressBook = (NodeAddressBook)NodeAddressBook.PROTOBUF.parse(nodeDetails);
            this.nodeInfos = nodeAddressBook.nodeAddress().stream().map(address -> new NodeInfoImpl(address.nodeId(), address.nodeAccountIdOrThrow(), address.stake(), List.of(), Bytes.EMPTY, List.of(), false, null)).toList();
        }
        catch (ParseException e) {
            log.warn("Failed to parse node details", (Throwable)e);
            this.nodeInfos = Collections.emptyList();
        }
    }

    @NonNull
    public Bytes ledgerId() {
        return this.ledgerId;
    }

    @NonNull
    public NodeInfo selfNodeInfo() {
        return this.selfNodeInfo;
    }

    @NonNull
    public List<NodeInfo> addressBook() {
        return this.nodeInfosOrThrow();
    }

    @Nullable
    public NodeInfo nodeInfo(long nodeId) {
        return this.nodeInfosOrThrow().stream().filter(node -> node.nodeId() == nodeId).findFirst().orElse(null);
    }

    public boolean containsNode(long nodeId) {
        return this.nodeInfo(nodeId) != null;
    }

    public void updateFrom(State state) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NonNull
    private List<NodeInfo> nodeInfosOrThrow() {
        return Objects.requireNonNull(this.nodeInfos, "Not initialized");
    }
}

