/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.gascalculator.ShanghaiGasCalculator;

public class CancunGasCalculator
extends ShanghaiGasCalculator {
    private static final long TLOAD_GAS = 100L;
    private static final long TSTORE_GAS = 100L;
    public static final long BLOB_GAS_PER_BLOB = 131072L;
    public static final long TARGET_BLOB_GAS_PER_BLOCK = 393216L;

    public CancunGasCalculator() {
        this(Address.KZG_POINT_EVAL.toArrayUnsafe()[19]);
    }

    protected CancunGasCalculator(int maxPrecompile) {
        super(maxPrecompile);
    }

    @Override
    public long getTransientLoadOperationGasCost() {
        return 100L;
    }

    @Override
    public long getTransientStoreOperationGasCost() {
        return 100L;
    }

    @Override
    public long blobGasCost(int blobCount) {
        return 131072L * (long)blobCount;
    }

    public long getTargetBlobGasPerBlock() {
        return 393216L;
    }

    @Override
    public long computeExcessBlobGas(long parentExcessBlobGas, int newBlobs) {
        long consumedBlobGas = this.blobGasCost(newBlobs);
        long currentExcessBlobGas = parentExcessBlobGas + consumedBlobGas;
        if (currentExcessBlobGas < 393216L) {
            return 0L;
        }
        return currentExcessBlobGas - 393216L;
    }

    @Override
    public long computeExcessBlobGas(long parentExcessBlobGas, long parentBlobGasUsed) {
        long currentExcessBlobGas = parentExcessBlobGas + parentBlobGasUsed;
        if (currentExcessBlobGas < 393216L) {
            return 0L;
        }
        return currentExcessBlobGas - 393216L;
    }
}

