/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.exports;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import com.hedera.node.app.hapi.utils.exports.recordstreaming.RecordStreamingUtils;
import com.hedera.services.stream.proto.HashAlgorithm;
import com.hedera.services.stream.proto.HashObject;
import com.hedera.services.stream.proto.RecordStreamFile;
import com.hedera.services.stream.proto.SignatureFile;
import com.hedera.services.stream.proto.SignatureObject;
import com.hedera.services.stream.proto.SignatureType;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.stream.EventStreamType;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.StreamTypeFromJson;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.HashingOutputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.CommonUtils;

public class FileSignTool {
    private static final String CSV_EXTENSION = ".csv";
    private static final String ACCOUNT_BALANCE_EXTENSION = ".pb";
    private static final String SIG_FILE_NAME_END = "_sig";
    private static final int DEFAULT_RECORD_STREAM_VERSION = 6;
    private static final String STREAM_TYPE_JSON_PROPERTY = "streamTypeJson";
    private static final String LOG_CONFIG_PROPERTY = "logConfig";
    private static final String FILE_NAME_PROPERTY = "fileName";
    private static final String KEY_PROPERTY = "key";
    private static final String DEST_DIR_PROPERTY = "destDir";
    private static final String ALIAS_PROPERTY = "alias";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String DIR_PROPERTY = "dir";
    private static final String HAPI_PROTOBUF_VERSION = "hapiProtoVersion";
    private static final Logger LOGGER = LogManager.getLogger(FileSignTool.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"FILE_SIGN");
    private static final String DEFAULT_LOG_CONFIG = "log4j2.xml";
    private static final String KEYSTORE_TYPE = "pkcs12";
    private static final String RECORD_STREAM_EXTENSION = "rcd";
    private static final String COMPRESSED_RECORD_STREAM_EXTENSION = "rcd.gz";
    private static final DigestType currentDigestType = Cryptography.DEFAULT_DIGEST_TYPE;
    private static MessageDigest streamDigest;
    private static MessageDigest metadataStreamDigest;

    private FileSignTool() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] sign(byte[] data, KeyPair sigKeyPair) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(org.hiero.base.crypto.SignatureType.RSA.signingAlgorithm(), org.hiero.base.crypto.SignatureType.RSA.provider());
        signature.initSign(sigKeyPair.getPrivate());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(MARKER, "data being signed = {}", (Object)CommonUtils.hex((byte[])data));
        }
        signature.update(data);
        return signature.sign();
    }

    public static KeyPair loadPfxKey(String keyFileName, String password, String alias) {
        KeyPair sigKeyPair = null;
        try (FileInputStream fis = new FileInputStream(keyFileName);){
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(fis, password.toCharArray());
            sigKeyPair = new KeyPair(keyStore.getCertificate(alias).getPublicKey(), (PrivateKey)keyStore.getKey(alias, password.toCharArray()));
            LOGGER.info(MARKER, "keypair has loaded successfully from file {}", (Object)keyFileName);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            LOGGER.error(MARKER, "loadPfxKey :: ERROR ", (Throwable)e);
        }
        return sigKeyPair;
    }

    public static String buildDestSigFilePath(File destDir, File streamFile) {
        String sigFileName = streamFile.getName() + SIG_FILE_NAME_END;
        return new File(destDir, sigFileName).getPath();
    }

    public static void signSingleFile(KeyPair sigKeyPair, File streamFile, File destDir, StreamType streamType) {
        String destSigFilePath = FileSignTool.buildDestSigFilePath(destDir, streamFile);
        try {
            if (streamType.getExtension().equalsIgnoreCase(RECORD_STREAM_EXTENSION)) {
                FileSignTool.createSignatureFileForRecordFile(streamFile.getAbsolutePath(), streamType, sigKeyPair, destDir.getPath());
                return;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            LOGGER.error(MARKER, "Failed to sign file {} ", (Object)streamFile.getName(), (Object)e);
        }
        LOGGER.info(MARKER, "Finish generating signature file {}", (Object)destSigFilePath);
    }

    public static StreamType loadStreamTypeFromJson(String jsonPath) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File(jsonPath);
        return (StreamType)objectMapper.readValue(file, StreamTypeFromJson.class);
    }

    public static void prepare(StreamType streamType) throws ConstructableRegistryException {
        ConstructableRegistry registry = ConstructableRegistry.getInstance();
        registry.registerConstructables("com.swirlds.common");
        registry.registerConstructables("org.hiero");
        if (streamType.getExtension().equalsIgnoreCase(RECORD_STREAM_EXTENSION)) {
            LOGGER.info(MARKER, "registering Constructables for parsing record stream files");
            registry.registerConstructables("com.hedera.services.stream");
        }
    }

    private static ByteString wrapUnsafely(@NonNull byte[] bytes) {
        return UnsafeByteOperations.unsafeWrap((byte[])bytes);
    }

    private static SignatureObject generateSignatureObject(byte[] hash, KeyPair sigKeyPair) throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        byte[] signature = FileSignTool.sign(hash, sigKeyPair);
        return SignatureObject.newBuilder().setType(SignatureType.SHA_384_WITH_RSA).setLength(signature.length).setChecksum(101 - signature.length).setSignature(FileSignTool.wrapUnsafely(signature)).setHashObject(FileSignTool.toProto(hash)).build();
    }

    private static HashObject toProto(byte[] hash) {
        return HashObject.newBuilder().setAlgorithm(HashAlgorithm.SHA_384).setLength(currentDigestType.digestLength()).setHash(FileSignTool.wrapUnsafely(hash)).build();
    }

    private static void createSignatureFileForRecordFile(String recordFile, StreamType streamType, KeyPair sigKeyPair, String destSigFilePath) throws NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        String[] versions;
        int[] fileHeader = streamType.getFileHeader();
        String appVersionString = System.getProperty(HAPI_PROTOBUF_VERSION);
        if (appVersionString != null && (versions = appVersionString.replace("-SNAPSHOT", "").split(Pattern.quote("-"))[0].split(Pattern.quote("."))).length >= 3) {
            try {
                fileHeader = new int[]{6, Integer.parseInt(versions[0]), Integer.parseInt(versions[1]), Integer.parseInt(versions[2])};
            }
            catch (NumberFormatException e) {
                LOGGER.error(MARKER, "Error when parsing app version string {}", (Object)appVersionString, (Object)e);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            String fileHeaderString = Arrays.toString(fileHeader);
            LOGGER.info(MARKER, "Record stream file header is {}", (Object)fileHeaderString);
        }
        try (SerializableDataOutputStream dosMeta = new SerializableDataOutputStream((OutputStream)new HashingOutputStream(metadataStreamDigest));
             SerializableDataOutputStream dos = new SerializableDataOutputStream((OutputStream)new BufferedOutputStream((OutputStream)new HashingOutputStream(streamDigest)));){
            Pair<Integer, Optional<RecordStreamFile>> recordResult = RecordStreamingUtils.readMaybeCompressedRecordStreamFile(recordFile);
            if (recordResult == null || ((Optional)recordResult.getValue()).isEmpty()) {
                throw new RuntimeException("Record result is empty");
            }
            long blockNumber = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getBlockNumber();
            byte[] startRunningHash = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getStartObjectRunningHash().getHash().toByteArray();
            byte[] endRunningHash = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).getEndObjectRunningHash().getHash().toByteArray();
            int version = (Integer)recordResult.getKey();
            byte[] serializedBytes = ((RecordStreamFile)((Optional)recordResult.getValue()).get()).toByteArray();
            if (LOGGER.isInfoEnabled()) {
                String string = Arrays.toString(fileHeader);
                LOGGER.info(MARKER, "Writing file header {}", (Object)string);
            }
            for (int value : fileHeader) {
                dosMeta.writeInt(value);
            }
            String string = CommonUtils.hex((byte[])startRunningHash);
            LOGGER.info(MARKER, "Writing start running hash {}", (Object)string);
            dosMeta.write(startRunningHash);
            String endRunningHashHex = CommonUtils.hex((byte[])endRunningHash);
            LOGGER.info(MARKER, "Writing end running hash {}", (Object)endRunningHashHex);
            dosMeta.write(endRunningHash);
            LOGGER.info(MARKER, "Writing block number {}", (Object)blockNumber);
            dosMeta.writeLong(blockNumber);
            dosMeta.flush();
            LOGGER.info(MARKER, "Writing version {}", (Object)version);
            dos.writeInt(version);
            if (LOGGER.isInfoEnabled()) {
                String serializedBytesSubstring = CommonUtils.hex((byte[])serializedBytes).substring(0, 32);
                LOGGER.info(MARKER, "Writing serializedBytes {}", (Object)serializedBytesSubstring);
            }
            dos.write(serializedBytes);
            dos.flush();
        }
        catch (IOException e) {
            String message = String.format("Got IOException when reading record file %s, error = %s", recordFile, e);
            Thread.currentThread().interrupt();
            LOGGER.error(MARKER, message);
            throw new RuntimeException(message);
        }
        SignatureObject metadataSignature = FileSignTool.generateSignatureObject(metadataStreamDigest.digest(), sigKeyPair);
        SignatureObject fileSignature = FileSignTool.generateSignatureObject(streamDigest.digest(), sigKeyPair);
        SignatureFile.Builder signatureFile = SignatureFile.newBuilder().setFileSignature(fileSignature).setMetadataSignature(metadataSignature);
        String sigFilePath = (String)(recordFile.endsWith(".gz") ? Paths.get("", new String[0]).toAbsolutePath().toString() + File.separator + "tmp" + File.separator + String.valueOf(Paths.get(recordFile.replace(".gz", ""), new String[0]).getFileName()) : recordFile) + SIG_FILE_NAME_END;
        try (FileOutputStream fos = new FileOutputStream(destSigFilePath + File.separator + new File(sigFilePath).getName());){
            fos.write(streamType.getSigFileHeader()[0]);
            signatureFile.build().writeTo((OutputStream)fos);
            LOGGER.debug(MARKER, "Signature file saved: {}", (Object)sigFilePath);
        }
        catch (IOException e) {
            LOGGER.error(MARKER, "Fail to generate signature file for {}", (Object)recordFile, (Object)e);
        }
    }

    private static void initRecordDigest() {
        try {
            streamDigest = MessageDigest.getInstance(currentDigestType.algorithmName());
            metadataStreamDigest = MessageDigest.getInstance(currentDigestType.algorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(MARKER, "Failed to create message digest", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        block10: {
            File logConfigFile;
            String streamTypeJsonPath = System.getProperty(STREAM_TYPE_JSON_PROPERTY);
            EventStreamType streamType = EventStreamType.getInstance();
            if (streamTypeJsonPath != null) {
                try {
                    streamType = FileSignTool.loadStreamTypeFromJson(streamTypeJsonPath);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "fail to load StreamType from {}.", (Object)streamTypeJsonPath, (Object)e);
                    return;
                }
            }
            try {
                FileSignTool.prepare((StreamType)streamType);
                FileSignTool.initRecordDigest();
            }
            catch (ConstructableRegistryException e) {
                LOGGER.error(MARKER, "fail to register constructables.", (Throwable)e);
                return;
            }
            String logConfigPath = System.getProperty(LOG_CONFIG_PROPERTY);
            File file = logConfigFile = logConfigPath == null ? FileUtils.getAbsolutePath().resolve(DEFAULT_LOG_CONFIG).toFile() : new File(logConfigPath);
            if (logConfigFile.exists()) {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(logConfigFile.toURI());
                String fileName = System.getProperty(FILE_NAME_PROPERTY);
                String keyFileName = System.getProperty(KEY_PROPERTY);
                String destDirName = System.getProperty(DEST_DIR_PROPERTY);
                String alias = System.getProperty(ALIAS_PROPERTY);
                String password = System.getProperty(PASSWORD_PROPERTY);
                KeyPair sigKeyPair = FileSignTool.loadPfxKey(keyFileName, password, alias);
                String fileDirName = System.getProperty(DIR_PROPERTY);
                try {
                    File destDir = new File(Files.createDirectories(Paths.get(destDirName, new String[0]), new FileAttribute[0]).toUri());
                    if (fileDirName != null) {
                        FileSignTool.signAllFiles(fileDirName, destDirName, (StreamType)streamType, sigKeyPair);
                        break block10;
                    }
                    FileSignTool.signSingleFile(sigKeyPair, new File(fileName), destDir, (StreamType)streamType);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Got IOException", (Throwable)e);
                }
            } else {
                throw new RuntimeException("Could not find log4j2 configuration file " + String.valueOf(logConfigFile));
            }
        }
    }

    public static void signAllFiles(String sourceDir, String destDir, StreamType streamType, KeyPair sigKeyPair) throws IOException {
        Object[] accountBalanceFiles;
        LOGGER.info(MARKER, "Signing all files in {} and writing signatures to {}", (Object)sourceDir, (Object)destDir);
        File destDirFile = new File(Files.createDirectories(Paths.get(destDir, new String[0]), new FileAttribute[0]).toUri());
        File folder = new File(sourceDir);
        Object[] streamFiles = folder.listFiles((dir, name) -> streamType.isStreamFile(name) || name.endsWith(COMPRESSED_RECORD_STREAM_EXTENSION));
        if (streamFiles == null || streamFiles.length == 0) {
            LOGGER.error(MARKER, "No stream files found in {}", (Object)sourceDir);
        }
        if ((accountBalanceFiles = folder.listFiles((dir, name) -> {
            String lowerCaseName = name.toLowerCase();
            return lowerCaseName.endsWith(CSV_EXTENSION) || lowerCaseName.endsWith(ACCOUNT_BALANCE_EXTENSION);
        })) == null || accountBalanceFiles.length == 0) {
            LOGGER.error(MARKER, "No account balance files found in {}", (Object)sourceDir);
        }
        Arrays.sort(streamFiles);
        Arrays.sort(accountBalanceFiles);
        ArrayList<File> totalList = new ArrayList<File>();
        totalList.addAll(Arrays.asList((File[])Optional.ofNullable(streamFiles).orElse(new File[0])));
        totalList.addAll(Arrays.asList((File[])Optional.ofNullable(accountBalanceFiles).orElse(new File[0])));
        for (File item : totalList) {
            FileSignTool.signSingleFile(sigKeyPair, item, destDirFile, streamType);
        }
    }
}

