/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.metrics;

import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class NodeMetrics {
    private static final String APP_CATEGORY = "app_";
    private static final Logger log = LogManager.getLogger(NodeMetrics.class);
    private final Map<Long, RunningAverageMetric> activeRoundsAverages = new HashMap<Long, RunningAverageMetric>();
    private final Map<Long, DoubleGauge> activeRoundsSnapshots = new HashMap<Long, DoubleGauge>();
    private final Metrics metrics;

    @Inject
    public NodeMetrics(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
    }

    public void registerNodeMetrics(@NonNull List<RosterEntry> rosterEntries) {
        for (RosterEntry entry : rosterEntries) {
            long nodeId = entry.nodeId();
            String name = "nodeActivePercent_node" + nodeId;
            String snapshotName = "nodeActivePercentSnapshot_node" + nodeId;
            if (!this.activeRoundsAverages.containsKey(nodeId)) {
                RunningAverageMetric averageMetric = (RunningAverageMetric)this.metrics.getOrCreate((MetricConfig)new RunningAverageMetric.Config(APP_CATEGORY, name).withDescription("Active round % average for node " + nodeId));
                this.activeRoundsAverages.put(nodeId, averageMetric);
            }
            if (this.activeRoundsSnapshots.containsKey(nodeId)) continue;
            DoubleGauge snapshot = (DoubleGauge)this.metrics.getOrCreate((MetricConfig)new DoubleGauge.Config(APP_CATEGORY, snapshotName).withDescription("Active round % snapshot for node " + nodeId));
            this.activeRoundsSnapshots.put(nodeId, snapshot);
        }
    }

    public void updateNodeActiveMetrics(long nodeId, double activePercent) {
        if (this.activeRoundsAverages.containsKey(nodeId)) {
            this.activeRoundsAverages.get(nodeId).update(activePercent);
        }
        if (this.activeRoundsSnapshots.containsKey(nodeId)) {
            this.activeRoundsSnapshots.get(nodeId).set(activePercent);
        }
    }
}

